/* -*- Mode: C++ -*- */

#ifndef _LOGFILE_RUNNER_H_
#define _LOGFILE_RUNNER_H_

#include <iostream>
#include <fstream>
#include <pthread.h>
#define HAVE_LIBZ
// I wrote a version of gzfstream; it might end up in the serer distribution at some point
#include "gzfstream.h"
#include "Runner.h"
#include "WorldHistory.h"
#include "LogfileDataHandler.h"
#include "PlayerTypeStorage.h"
#include "soccer_utils.h"
#include "CoachTagFunction.h"
#include "utility.h"

/**********************************************************************************/

class LogfileRunner
  : public Runner, public TimeTagger
{
public:
  LogfileRunner(ModuleRegistry* pReg);
  ~LogfileRunner();

  // this method should call all of the the dependency check methods of the appropriate
  // type
  bool dependencyCheck(ModuleRegistry* pReg);

  // the method to enter the loop and do all the work
  bool run();

  const std::string& getLeftTeamName() const { return left_team_name; }
  const std::string& getRightTeamName() const { return right_team_name; }
  //If left and right have not been set, this will set the team name, so you can't ask
  // about arbitrary names
  TeamSide getSideOf(const char* team_name);
  TeamSide determineSide(const char* side_str, const char* team_str)
  { return ::determineSide(side_str, team_str, left_team_name.c_str(), right_team_name.c_str()); }

  TeamSide getSideToAnalyze() const { return side_to_analyze; }
  
  const WorldHistory& getWorldHistory() const { return history; }
  const PlayerTypeStorage& getPlayerTypeStorage() const { return player_type_storage; }

  //This is the time tagger method
  std::string getTime() const
  { return spades::toString(history.getNumAvail() ? history.getWorldState().getTime() : -1); }

protected:
  friend class LogfileDataHandler;

  void doSetTeamNames(const char* left_team_name, const char* right_team_name);
  
  void prot_initiateShutdown();

  WorldHistory history;

  PlayerTypeStorage player_type_storage;
  
private:
  // We can always use gzifstream because zlib will recongize an uncompressed file and DTRT
  rcss::gz::gzifstream is_logfile;
  
  LogfileDataHandler data_handler;

  TeamSide side_to_analyze;

  std::string left_team_name;
  std::string right_team_name;
  
};



#endif
