/* -*- Mode: C++ -*- */

#ifndef _LOGFILE_DATA_HANDLER_H_
#define _LOGFILE_DATA_HANDLER_H_

#include <rcsslogplayer/rcgparser.hpp>
#include <rcsslogplayer/rcgdatahandler.hpp>
#include "WorldState.h"

class LogfileRunner;

class LogfileDataHandler
  : public rcss::RCGDataHandler
{
public:
  LogfileDataHandler(LogfileRunner* runner);
  ~LogfileDataHandler();

  bool wasLastMsgShowInfo() const { return was_last_msg_showinfo; }
  
protected:
  void doHandleLogVersion( int ver );
  int doGetLogVersion() const { return ver; }
  void doHandleDispInfo( std::streampos, 
			 const dispinfo_t& );
  void doHandleShowInfo( std::streampos,
			 const showinfo_t& );
  void doHandleShowInfo( std::streampos, 
			 const short_showinfo_t2& );
  void doHandleMsgInfo( std::streampos, 
			short,
			const std::string& );
  void doHandlePlayMode( std::streampos, 
			 char );
  void doHandleTeamInfo( std::streampos,
			 const team_t&,
			 const team_t& );
  void doHandleServerParams( std::streampos,
			     const server_params_t& );
  void doHandlePlayerParams( std::streampos,
			     const player_params_t& );
  void doHandlePlayerType( std::streampos,
			   const player_type_t& );
  void doHandleEOF();

  
private:
  LogfileRunner* runner;
  int ver;
  bool was_last_msg_showinfo;

  // the error in a logfile number from the scale to int thing that happens
  static const double LOGFILE_LONG_2_ERROR;
  
  static BallInfo convertBallInfo(const ball_t& b);
  //idx is the index in the logfile struct -- gives the team and number
  static PlayerInfo convertPlayerInfo(int idx, const player_t& p);
};




#endif
