/* This class stores the log of a double instead of the double itself.
   This gives high precision when the number is near to 0 */
/* most of the implementation is given in the .h file */

#include "LogDouble.h"


bool LogDouble::operator <(const LogDouble &a) const
{
  if (!pos && a.pos) {
    if (!(isinf(v)==-1 && isinf(a.v)==-1))
      return true;
    return false; //both are 0
  }

  if (pos && !a.pos)
    return false;

  //signs must be same here
  return (v<a.v) ? (pos) : (!pos);
}

bool LogDouble::operator<=(const LogDouble &a) const
{
  if (!pos && a.pos) {
    return true; 
  }

  if (pos && !a.pos) {
    return false;
  }
  
  //signs must be same here
  return (v<=a.v) ? (pos) : (!pos);
}

bool LogDouble::operator >(const LogDouble &a) const
{
  if (!pos && a.pos) {
    return false; 
  }

  if (pos && !a.pos) {
    if (!(isinf(v)==-1 && isinf(a.v)==-1))
      return true;
    return false; //both are 0
  }
  
  //signs must be same here
  return (v>a.v) ? (pos) : (!pos);
}

bool LogDouble::operator>=(const LogDouble &a) const
{
  if (!pos && a.pos) {
    return false; 
  }

  if (pos && !a.pos) {
    return true;
  }
  
  //signs must be same here
  return (v>=a.v) ? (pos) : (!pos);
}
