/* -*- Mode: C++ -*- */

#ifndef _H_HETEROPLAYER_TYPE
#define _H_HETEROPLAYER_TYPE

#include <iostream>

class HeteroPlayerType
{
public:
  HeteroPlayerType();
  HeteroPlayerType (float psm, float sim, float pd, float im, 
		    float dpr, float ps, float km, float kr, float es, 
		    float emax, float emin);
  HeteroPlayerType (float val);
  ~HeteroPlayerType ();
  
  float getPlayerSpeedMax() const { return player_speed_max;}
  float getStaminaIncMax() const { return stamina_inc_max;}
  float getPlayerDecay() const { return player_decay;}
  float getInertiaMoment() const { return inertia_moment;}
  float getDashPowerRate() const { return dash_power_rate;}
  float getPlayerSize() const { return player_size;}
  float getKickableMargin() const { return kickable_margin;}
  float getKickableArea() const;
  float getKickRand() const { return kick_rand;}
  float getExtraStamina() const { return extra_stamina;}
  float getEffortMax() const { return effort_max;}
  float getEffortMin() const { return effort_min;}

  HeteroPlayerType maxCombineWith(const HeteroPlayerType& t) const;
  HeteroPlayerType minCombineWith(const HeteroPlayerType& t) const;

  friend std::ostream & operator << (std::ostream & o, const HeteroPlayerType& t);
  
private:
   float player_speed_max;
   float stamina_inc_max;
   float player_decay;
   float inertia_moment;
   float dash_power_rate;
   float player_size;
   float kickable_margin;
   float kick_rand;
   float extra_stamina;
   float effort_max;
   float effort_min;
};


#endif
