/* -*- Mode: C++ -*- */

#include "HeteroPlayerType.h"
#include "ServerParam.h"
#include "misc.h"

HeteroPlayerType::HeteroPlayerType ()
{
  player_speed_max = -1;
  stamina_inc_max = -1;
  player_decay = -1;
  inertia_moment = -1;
  dash_power_rate = -1;
  player_size = -1;
  kickable_margin = -1;
  kick_rand = -1;
  extra_stamina = -1;
  effort_max = -1;
  effort_min = -1;
}

HeteroPlayerType::HeteroPlayerType (float psm, float sim, float pd, 
				    float im, float dpr, float ps, float km, float kr, float es, 
				    float emax, float emin)
{
  player_speed_max = psm;
  stamina_inc_max = sim;
  player_decay = pd;
  inertia_moment = im;
  dash_power_rate = dpr;
  player_size = ps;
  kickable_margin = km;
  kick_rand = kr;
  extra_stamina = es;
  effort_max = emax;
  effort_min = emin;
}

HeteroPlayerType::HeteroPlayerType (float val)
{
  player_speed_max = val;
  stamina_inc_max = val;
  player_decay = val;
  inertia_moment = val;
  dash_power_rate = val;
  player_size = val;
  kickable_margin = val;
  kick_rand = val;
  extra_stamina = val;
  effort_max = val;
  effort_min = val;
}

HeteroPlayerType::~HeteroPlayerType()
{
}

float HeteroPlayerType::getKickableArea() const 
{
  return player_size + ServerParam::instance()->getSPBallSize() + kickable_margin;
}


HeteroPlayerType HeteroPlayerType::maxCombineWith(const HeteroPlayerType& t) const
{
  HeteroPlayerType out;
  out.player_speed_max = Max(player_speed_max, t.player_speed_max);
  out.stamina_inc_max  = Max(stamina_inc_max, t.stamina_inc_max);
  out.player_decay     = Max(player_decay, t.player_decay);
  out.inertia_moment   = Max(inertia_moment, t.inertia_moment);
  out.dash_power_rate  = Max(dash_power_rate, t.dash_power_rate);
  out.player_size      = Max(player_size, t.player_size);
  out.kickable_margin  = Max(kickable_margin, t.kickable_margin);
  out.kick_rand        = Max(kick_rand, t.kick_rand);
  out.extra_stamina    = Max(extra_stamina, t.extra_stamina);
  out.effort_max       = Max(effort_max, t.effort_max);
  out.effort_min       = Max(effort_min, t.effort_min);
  return out;
}

HeteroPlayerType HeteroPlayerType::minCombineWith(const HeteroPlayerType& t) const
{
  HeteroPlayerType out;
  out.player_speed_max = Min(player_speed_max, t.player_speed_max);
  out.stamina_inc_max  = Min(stamina_inc_max, t.stamina_inc_max);
  out.player_decay     = Min(player_decay, t.player_decay);
  out.inertia_moment   = Min(inertia_moment, t.inertia_moment);
  out.dash_power_rate  = Min(dash_power_rate, t.dash_power_rate);
  out.player_size      = Min(player_size, t.player_size);
  out.kickable_margin  = Min(kickable_margin, t.kickable_margin);
  out.kick_rand        = Min(kick_rand, t.kick_rand);
  out.extra_stamina    = Min(extra_stamina, t.extra_stamina);
  out.effort_max       = Min(effort_max, t.effort_max);
  out.effort_min       = Min(effort_min, t.effort_min);
  return out;
}


std::ostream&
operator<< (std::ostream & o, const HeteroPlayerType& t)
{
  o << "(player_type "
    << "(player_speed_max " << t.player_speed_max << ")"
    << "(stamina_inc_max " << t.stamina_inc_max << ")"
    << "(player_decay " << t.player_decay << ")"
    << "(inertia_moment " << t.inertia_moment << ")"
    << "(dash_power_rate " << t.dash_power_rate << ")"
    << "(player_size " << t.player_size << ")"
    << "(kickable_margin " << t.kickable_margin << ")"
    << "(kick_rand " << t.kick_rand << ")"
    << "(extra_stamina " << t.extra_stamina << ")"
    << "(effort_max " << t.effort_max << ")"
    << "(effort_min " << t.effort_min << ")"
    << ")";
  return o;
}
