/* -*- Mode: C++ -*- */

#ifndef _GASTRATEGYSELECTOR_H_
#define _GASTRATEGYSELECTOR_H_

#include <string>
#include "GAPredicateAdaptor.h"
#include "ModGlobalAdapt.h"

/* This class provides a simpler interface to what is provided by ModGlobalAdapt
   and associated storage to be used by objects that chose the next Strategy */

/*****************************************************************************/

class GAStrategySelector
{
public:
  GAStrategySelector(const char* name) : name(name) {}
  virtual ~GAStrategySelector() {}

  const std::string& getName() const { return name; }

  friend std::ostream& operator<<(std::ostream& os, const GAStrategySelector& gass)
  { os << "GAStrategySelector(" << gass.getName() << ")"; return os; }

  virtual StrategySpec selectNewStrategy(GAPredicateAdaptor& pred) = 0;
  
private:
  std::string name;
};

/*****************************************************************************/

// just advances through the strategies one by one
class GASS_Fixed
  : public GAStrategySelector
{
public:
  GASS_Fixed(const StrategySpec& spec)
    : GAStrategySelector("Fixed"), spec(spec) {}

  StrategySpec selectNewStrategy(GAPredicateAdaptor& pred);

private:
  StrategySpec spec;
};

/*****************************************************************************/

// just advances through the strategies one by one
class GASS_FixedAdvance
  : public GAStrategySelector
{
public:
  GASS_FixedAdvance() : GAStrategySelector("FixedAdvance") {}

  StrategySpec selectNewStrategy(GAPredicateAdaptor& pred);
  
};

/*****************************************************************************/

class GASS_SimpleHandCoded
  : public GAStrategySelector
{
public:
  GASS_SimpleHandCoded() : GAStrategySelector("SimpleHandCoded") {}

  StrategySpec selectNewStrategy(GAPredicateAdaptor& pred);

private:
  StrategySpec handleWinning(GAPredicateAdaptor& pred);
  StrategySpec handleTied(GAPredicateAdaptor& pred);
  StrategySpec handleLosing(GAPredicateAdaptor& pred);

  void addToTrace(const char* s);
  void clearTrace() { trace_mess.clear(); }
  const std::string& getTraceMess() const { return trace_mess; }
  
  // used to trace the exec
  std::string trace_mess;
};

#endif
