/* -*- Mode: C++ -*- */

#include "GAStrategySelector.h"
#include "ServerParam.h"
#include "Logger.h"

using namespace spades;

/*****************************************************************************/

StrategySpec
GASS_Fixed::selectNewStrategy(GAPredicateAdaptor& pred)
{
  return spec;
}

/*****************************************************************************/

StrategySpec
GASS_FixedAdvance::selectNewStrategy(GAPredicateAdaptor& pred)
{
  if (pred.globalHistoryCycles() <= 1)
    return pred.getCurrentStrategy();
      
  unsigned newidx = pred.getFlatIdxOf(pred.getCurrentStrategy()) + 1;
  if (newidx >= pred.getFlatStrategySpace().size())
    newidx = 0;
  
  return pred.getFlatStrategySpace()[newidx];
}

/*****************************************************************************/
StrategySpec
GASS_SimpleHandCoded::selectNewStrategy(GAPredicateAdaptor& pred)
{
  StrategySpec spec(AS_Invalid, 0);
  
  clearTrace();
  
  if (pred.globalHistoryCycles() <= 1)
    {
      addToTrace("Initial");
      spec = pred.getCurrentStrategy();
    }
  else if (pred.winning())
    {
      addToTrace("Winning");
      spec = handleWinning(pred);
    }
  else if (pred.tied())
    {
      addToTrace("Tied");
      spec = handleTied(pred);
    }
  else if (pred.losing())
    {
      addToTrace("Losing");
      spec = handleLosing(pred);
    }
  else
    {
      addToTrace("ERR:w/l/t");
      errorlog << "GASS_SimpleHandCoded: not winning, tied, or losing?" << ende;
      spec = pred.getCurrentStrategy();
    }

  actionlog(30) << "GASS_SimpleHandCoded: chose " << spec << " by: "
                << getTraceMess() << ende;
  std::cout << "GASS_SimpleHandCoded: chose " << spec << " by: " 
            << getTraceMess() << std::endl;
  return spec;
}

StrategySpec
GASS_SimpleHandCoded::handleWinning(GAPredicateAdaptor& pred)
{
  // this tests if we are surprised to be winning
  if (pred.globalMeanScoreDiffPerCycle() <= 0 &&
      pred.meanScoreDiffPerCycle(pred.getStrategyWBestScoreDiff()) < 1.0/ServerParam::instance()->getSPHalfCycles())
    {
      // Surprised to be winning -- try and hold onto victory
      addToTrace("Surprise");
      if (pred.getQuarter() >= 4)
	{
	  // in last quarter of game
          addToTrace("LastQ");
	  StrategySpec scoreless_ss = pred.getScorelessStrategyWData();
	  StrategySpec best_sd = pred.getStrategyWDataAndBestScoreDiff();
	  if (scoreless_ss.getAdaptStyle() != AS_Invalid)
	    {
              addToTrace("Scoreless");
	      return scoreless_ss;
	    }
	  else if (best_sd.getAdaptStyle() != AS_Invalid &&
		   pred.meanScoreDiffPerCycle(best_sd) * pred.getCyclesLeft() > -pred.getScoreDiff())
	    {
              addToTrace("BestSD");
	      return best_sd;
	    }
	  else
	    {
              // Try more off if it needs data, otherwise, best mean SD
              addToTrace("HowHold");
              StrategySpec more_off = pred.getMoreOffThatNeedsData(pred.getCurrentStrategy());
              if (more_off.getAdaptStyle() != AS_Invalid)
                {
                  addToTrace("MoreONeedData");
                  return more_off;
                }
              else
                {
                  StrategySpec best_sd_w_data = pred.getStrategyWDataAndBestScoreDiff();
                  if (best_sd_w_data.getAdaptStyle() != AS_Invalid)
                    {
                      addToTrace("BestSDWData");
                      return best_sd_w_data;
                    }
                  addToTrace("Current");
                  return pred.getCurrentStrategy();
                }
	    }
	}
      else if (pred.getQuarter() >= 1)
	{
	  // in the beginning to middle of game
          addToTrace("!LastQ");
          return pred.getCurrentStrategy();
	}
      else
	{
          addToTrace("ERR:quarter");
	  errorlog << "GASS_SimpleHandCoded::handleWinning: what is quarter " << pred.getQuarter() << ende;
	}
    }
  else
    {
      // Not surprised to be winning -- try and run up the score!
      // Try more off if it needs data, otherwise, best mean SD
      addToTrace("!Suprise");
      StrategySpec more_off = pred.getMoreOffThatNeedsData(pred.getCurrentStrategy());
      if (more_off.getAdaptStyle() != AS_Invalid)
        {
          addToTrace("MoreOffNeedD");
          return more_off;
        }
      else
        {
          StrategySpec best_sd_w_data = pred.getStrategyWDataAndBestScoreDiff();
          if (best_sd_w_data.getAdaptStyle() != AS_Invalid)
            {
              addToTrace("BestSDWData");
              return best_sd_w_data;
            }
          addToTrace("Current");
          return pred.getCurrentStrategy();
        }
    }

  addToTrace("ERR:winend");
  errorlog << "GASS_SimpleHandCoded::handleWinning: I shouldn't get here" << ende;
  return pred.getCurrentStrategy();
}

StrategySpec
GASS_SimpleHandCoded::handleTied(GAPredicateAdaptor& pred)
{
  StrategySpec best_sd_w_data = pred.getStrategyWDataAndBestScoreDiff();
  if (best_sd_w_data.getAdaptStyle() != AS_Invalid &&
      pred.meanScoreDiffPerCycle(best_sd_w_data) > 0)
    {
      addToTrace("UseBestSD");
      return best_sd_w_data;
    }
  
  if (pred.hasGoodDataAmt(pred.getCurrentStrategy()))
    {
      addToTrace("CurrHasData");
      if (pred.looksBad(pred.getCurrentStrategy()))
	{
	  addToTrace("CurrLooksBad");
	  StrategySpec dspec = pred.getMoreDefThatNeedsData(pred.getCurrentStrategy());
	  if (dspec.getAdaptStyle() != AS_Invalid)
	    {
	      addToTrace("MoreDefNeedsData");
	      return dspec;
	    }
	  // If we're on our second game and we lost the first by 3 or more, don't switch to O
	  if ( !(pred.globalHistoryCycles() > ServerParam::instance()->getSPHalfCycles()*2 &&
		 pred.globalMeanScoreDiffPerCycle() * ServerParam::instance()->getSPHalfCycles() >= 3))
	    {
	      addToTrace("ConsiderO");
	      StrategySpec ospec = pred.getMoreOffThatNeedsData(pred.getCurrentStrategy());
	      if (ospec.getAdaptStyle() != AS_Invalid)
		{
		  addToTrace("MoreOffNeedsData");
		  return ospec;
		}
	    }
	  
	  addToTrace("DontGatherData");
	  StrategySpec best_mean_x = pred.getStrategyWBestMeanX();
	  if (best_mean_x.getAdaptStyle() != AS_Invalid && pred.meanBallX(best_mean_x) > 0)
	    {
	      addToTrace("MeanX>0");
	      return best_mean_x;
	    }
	  StrategySpec best_sd = pred.getStrategyWBestScoreDiff();
	  if (best_sd.getAdaptStyle() == AS_Invalid)
	    {
	      addToTrace("ERR:tied:no_best_sd");
	      errorlog << "GASS_SimpleHandCoded::handleTied: how do I have no best sd?" << ende;
	      return pred.getCurrentStrategy();
	    }
	  return best_sd;
	}
      else if (pred.looksGood(pred.getCurrentStrategy()))
	{
	  StrategySpec ospec = pred.getMoreOffThatNeedsData(pred.getCurrentStrategy());
	  if (ospec.getAdaptStyle() != AS_Invalid)
	    {
	      addToTrace("MoreOffNeedsData");
	      return ospec;
	    }
	  addToTrace("BestMeanX");
	  StrategySpec best_mean_x = pred.getStrategyWBestMeanX();
	  if (best_mean_x.getAdaptStyle() == AS_Invalid)
	    {
	      addToTrace("ERR:NoBestMeanX");
	      return pred.getCurrentStrategy();
	    }
	  return best_mean_x;
	}
      else
	{
	  if (pred.timeForCurrentStrategyIsSmall())
	    {
	      addToTrace("CurrTimeSmall");
	      return pred.getCurrentStrategy();
	    }
	  else
	    {
	      // we want any offensive, so we pass in a bogus Normal
	      StrategySpec more_o = pred.getMoreOffThatNeedsData(StrategySpec(AS_Normal, 1000));
	      StrategySpec more_d = pred.getMoreDefThatNeedsData(StrategySpec(AS_Normal, 0));
	      StrategySpec best_sd = pred.getStrategyWBestScoreDiff();
	      if (pred.getCurrentStrategy().getAdaptStyle() == AS_Defensive ||
		  pred.getCurrentStrategy().getAdaptStyle() == AS_Normal)
		{
		  if (more_o.getAdaptStyle() != AS_Invalid)
		    {
		      addToTrace("TryingO");
		      return more_o;
		    }
		  else if (more_d.getAdaptStyle() != AS_Invalid)
		    {
		      addToTrace("TryingD");
		      return more_d;
		    }
		  else if (best_sd.getAdaptStyle() == AS_Invalid)
		    {
		      addToTrace("ERR:tied:no_best_sd");
		      errorlog << "GASS_SimpleHandCoded::handleTied: how do I have no best sd?" << ende;
		      return pred.getCurrentStrategy();
		    }
		  else
		    {
		      addToTrace("DToBestSD");
		      return best_sd;
		    }
		}
	      else if (pred.getCurrentStrategy().getAdaptStyle() == AS_Offensive)
		{
		  if (more_d.getAdaptStyle() != AS_Invalid)
		    {
		      addToTrace("TryingD");
		      return more_d;
		    }
		  else if (more_o.getAdaptStyle() != AS_Invalid)
		    {
		      addToTrace("TryingO");
		      return more_o;
		    }
		  else if (best_sd.getAdaptStyle() == AS_Invalid)
		    {
		      addToTrace("ERR:tied:no_best_sd");
		      errorlog << "GASS_SimpleHandCoded::handleTied: how do I have no best sd?" << ende;
		      return pred.getCurrentStrategy();
		    }
		  else
		    {
		      addToTrace("OToBestSD");
		      return best_sd;
		    }
		}
	      else
		{
		  addToTrace("ERR:tied:curr?");
		  errorlog << "GASS_SimpleHandCoded::handleTied: what the the style of the current strategy?"
			   << pred.getCurrentStrategy().getAdaptStyle()
			   << ende;
		  return pred.getCurrentStrategy();
		}
	    }
	}
    }
  else
    {
      addToTrace("!CurrHasData");
      if (pred.timeForCurrentStrategyIsSmall())
	{
	  addToTrace("CurrTimeSmall");
	  return pred.getCurrentStrategy();
	}
      else if (pred.looksBad(pred.getCurrentStrategy()))
	{
	  addToTrace("!CurrTimeSmall&LooksBad");
	  return pred.getMoreDef(pred.getCurrentStrategy());
	}
      else
	{
	  addToTrace("DefaultToCurrent");
	  return pred.getCurrentStrategy();
	}
    }
  
  addToTrace("ERR:tiedend");
  errorlog << "GASS_SimpleHandCoded::handleTied: how did I get to end" << ende;
  return pred.getCurrentStrategy();
}

StrategySpec
GASS_SimpleHandCoded::handleLosing(GAPredicateAdaptor& pred)
{
  StrategySpec best_sd_w_data = pred.getStrategyWDataAndBestScoreDiff();
  if (best_sd_w_data.getAdaptStyle() != AS_Invalid &&
      pred.meanScoreDiffPerCycle(best_sd_w_data) > 0)
    {
      addToTrace("HaveWinning");
      return best_sd_w_data;
    }
  else if (pred.haveDataForAll(AS_Defensive) &&
           pred.haveDataForAll(AS_Offensive))
    {
      addToTrace("HaveDOData");
      if (best_sd_w_data.getAdaptStyle() == AS_Invalid)
        {
          addToTrace("ERR:bestsd_inv");
          errorlog << "GASS_SimpleHandCoded::handleLosing: how is best_sd_w_data invalid "
                   << best_sd_w_data << ende;
          return pred.getCurrentStrategy();
        }
      return best_sd_w_data;
    }
  else if (pred.getMyGoals() == 0 &&
           pred.getTheirGoals() >= 2 &&
           pred.getTheirGoals() >= pred.globalMeanMyGoalsPerCycle() * pred.getCyclesLeft() ) 
    {
      addToTrace("NoHope");
      return StrategySpec(AS_Defensive, 0);
    }
  else
    {
      addToTrace("GetMoreData");
      // we want the most defensive that needs more data
      StrategySpec spec = pred.getMoreOffThatNeedsData(StrategySpec(AS_Invalid, -1));
      if (spec.getAdaptStyle() == AS_Invalid)
        {
          addToTrace("ERR:MoreDataInv");
          return pred.getCurrentStrategy();
        }
      return spec;
    }

  addToTrace("ERR:loseend");
  errorlog << "GASS_SimpleHandCoded::handleLosing: I shouldn't get here" << ende;
  return pred.getCurrentStrategy();
}

void
GASS_SimpleHandCoded::addToTrace(const char* s)
{
  trace_mess += s;
  trace_mess += " ";
}

