/* -*- Mode: C++ -*- */

/* this class provides functionality for learning a formation from data */

#ifndef _FORMATION_LEARNER_H_
#define _FORMATION_LEARNER_H_

#include <iostream>
#include <vector>
#include "Formation.h"
#include "data.h"

class FormationLearner
{
public:
  FormationLearner();
  ~FormationLearner();

  void setSideToLearn(TeamSide ts) { side_to_learn = ts; }
  TeamSide getSideToLearn() const { return side_to_learn; }
  
  // reads data (created by recordCurrDataToFile) into summary structures
  bool loadDataFrom(std::istream& is);

  // records positions of a file to be read in by loadDataFrom
  bool recordCurrDataToFile(std::ostream& o,const WorldState& ws);
  bool writeRecordHeader(std::ostream& o);
  
  // takes the current positions and loads them into the summary structures
  bool addCurrentToSummary(const WorldState& ws);

  // the reason we pass in f is so that the goalie permutation can be set
  // before the call
  bool learnFormation(Formation& f);
  
private:
  SingleDataSummary& getSdsPlayerDist(int num1, int num2);
  float simpleEvalFunction(const Rectangle& r, float point_fraction);
  float simpleEvalFunction(const Rectangle& r, const std::vector<VecPosition>& v);
  Rectangle FormationLearner::randomExplore(Rectangle start_rect,
					    const std::vector<VecPosition>& vpos);
  void FormationLearner::climbOnPlayerDistances(std::vector<Rectangle>& vRects,
						bool show_status);
  //0-based indexing
  void addToSummaries(const std::vector< std::pair<bool,VecPosition> >& v);
  
  // these are the summary structures
  TeamSide side_to_learn;
  //0-based arrays
  std::vector<SingleDataSummary> vSdsXPos;
  std::vector<SingleDataSummary> vSdsYPos;
  std::vector< std::vector<SingleDataSummary> > vvSdsPlayerDist;
  std::vector< std::vector<VecPosition> > vvPos;

};


#endif
