/* -*- Mode: C++ -*- */

/* This class provides fixed values for the RegionWorldModelInterface
   Useful for drawing without the conext of a WorldModel */

#ifndef FIXED_RWMI_H
#define FIXED_RWMI_H

#include "WorldModelInterface.h"

// This is the interface that regions need
class FixedRWMI
  : public RegionWorldModelInterface
{
public:
  FixedRWMI(bool use_right_side_coords = false)
    : use_right_side_coords(use_right_side_coords),
      ball_pos(5,5),
      our_x(-30),
      their_x(30),
      player_spacing(6)
  {}

  /*
   * Returns a vector holding the global position of the agent specified by num
   * The argument ourside is true if the player number specifies a player on our team
   * (and false if it is the opponent's team)
   */
  VecPosition
  getGlobalPosition(rcss::clang::UNum::unum_t num, 
		    bool ourside)
  {
    return VecPosition(ourside ? our_x : their_x,
		       (num - 6) * player_spacing); 
  }
  

  /*
   * Returns a vector containing the current ball position. 
   *
   */
  rcss::geom::Vector2D
  getBallPos() { return ball_pos.convertToVector2D(); }

  bool
  useRightSideCoordinates() { return use_right_side_coords; }

  bool getUseRightSideCoords() const { return use_right_side_coords; }
  void setUseRightSideCoords(bool b) { use_right_side_coords = b; }

  void setBallPos(VecPosition v) { ball_pos = v; }
  void setOurX(double x) { our_x = x; }
  void setTheirX(double x) { their_x = x; }
  void setPlayerSpacing(double s) { player_spacing = s; }
  
private:
  bool use_right_side_coords;

  VecPosition ball_pos;
  double our_x;
  double their_x;
  double player_spacing;
  
};


#endif

