/* -*- Mode: C++ -*- */

#ifndef _FIXEDADVICEAU_H_
#define _FIXEDADVICEAU_H_

#include <vector>
#include <map>
#include "ModGlobalAdapt.h"
#include "CoachMessageQueue.h"

class ModCMRep;

class FixedAdviceAdaptationUnit
  : public AdaptationUnit
{
public:
  FixedAdviceAdaptationUnit(ModuleRegistry* pReg, const char* infn);
  ~FixedAdviceAdaptationUnit();

  //this is the AdaptationUnit interface
  const char* getAdaptationUnitName() { return "FixedAdvice"; }
  int getNumStrategiesForStyle(AdaptStyle style);
  void changeStrategy(const StrategySpec& oldspec, const StrategySpec& newspec);

  bool addAdvice(AdaptStyle style, const char* rule_name, const char* fn);
  
private:
  void changeAdviceState(const StrategySpec& spec, bool on);
  
  // each element is a rule name to turn on/off
  typedef std::map<StrategySpec, std::string> RuleNamesStorage;
  typedef std::set<std::string> FilesReadSet;
  
  CoachMessageQueue mqueue;
  ModCMRep* pCMRep;
  RuleNamesStorage rule_names;
  FilesReadSet files_read;
  
};

#endif
