
#include <math.h>
#include "ErrBoundValue.h"
#include "misc.h"
#include "Logger.h"

using namespace spades;

// returns the multiplicative inverse
ErrBoundValue
ErrBoundValue::multInverse() const
{
  if (isPossibleValue(0.0))
    return ErrBoundValue(-HUGE_VAL, 1.0 / d, HUGE_VAL);
  double val = 1.0 / d;
  return ErrBoundValue(val, val - 1.0 / getUpperBound(), 1.0 / getLowerBound() - val, print_verbose);
}

ErrBoundValue
ErrBoundValue::operator*( const ErrBoundValue &p ) const
{
  ErrBoundValue out(d * p.d);
  double val_pp = getUpperBound() * p.getUpperBound();
  double val_pm = getUpperBound() * p.getLowerBound();
  double val_mp = getLowerBound() * p.getUpperBound();
  double val_mm = getLowerBound() * p.getLowerBound();

  out.setPrintVerbose(print_verbose);
  out.setBoundFromFourPoints(val_pp, val_pm, val_mp, val_mm);
  return out;
}

ErrBoundValue
ErrBoundValue::operator/( const ErrBoundValue &p ) const
{
  ErrBoundValue out = p.multInverse();
  out = *this * out;
  return out;
}


void
ErrBoundValue::setBoundFromFourPoints(double p1, double p2, double p3, double p4)
{
  lower = d - Min(Min(p1, p2), Min(p3, p4));
  upper = Max(Max(p1, p2), Max(p3, p4)) - d;
  if (lower < 0 || upper < 0)
    errorlog << "ErrBoundValue::setBoundFromFourPoints: Ended up with bad ranges!"
	     << "\td=" << d
	     << "\tp1=" << p1
	     << "\tp2=" << p2
	     << "\tp3=" << p3
	     << "\tp4=" << p4
	     << "\tlower=" << lower
	     << "\tupper=" << upper
	     << ende;
}

