/* -*- Mode: c++ -*- */

/* this little class helps with the logging */

#ifndef _COACHTAGFUNCTION_H_
#define _COACHTAGFUNCTION_H_

#include <string>
#include "Logger.h"
#include "utility.h"

// a simple interface that can be used by different runners to get the time
class TimeTagger
{
public:
  virtual std::string getTime() const { return "I"; } //I is for init
};

class CoachTagFunction
  : public spades::TagFunction
{
public:
  CoachTagFunction () : time_tagger(&s_plainTimeTagger) { }
  std::string getTag (int level) const
  { std::string s; s.insert (s.end (), level / 10, '-');  return time_tagger->getTime() + s;  }
  std::string getErrorTag (int level) const
  {
    return (level == 0 ? "CoachError " : ("CoachWarning[" + spades::toString(level) + "] "))
      + "(" + time_tagger->getTime() + "): ";
  }

  // The class does NOT take over this memory
  void setTimeTagger(const TimeTagger* pt) { time_tagger = pt; }
  void resetTimeTagger() { time_tagger = &s_plainTimeTagger; }
  
private:
  const TimeTagger* time_tagger;

  static const TimeTagger s_plainTimeTagger;
};

#endif
