/* -*- Mode: c++ -*- */

#ifndef _COACHPARAM_H_
#define _COACHPARAM_H_

#include "PlayerParam.h"

enum RunMode {
  RM_Invalid,
  RM_Null,
  RM_Single,
  RM_Online,
  RM_Logfile
};



class CoachParam
  : public PlayerParam
{
public:

  CoachParam ();
  virtual ~ CoachParam ();

  static CoachParam* instance() { return s_instance; }

private:
  static CoachParam* s_instance;
    
protected:
  //virtual void writeConfig ( ostream& o ) = 0;

  virtual void addAll2Maps ();
  virtual void setDefaultValues ();
  virtual void postReadProcessing ();

public:

  const std::string& getLogfileDir () const { return logfile_dir; }
  const std::string& getActionLogFN () const { return action_log_fn; }
  int getActionLogLevel () const { return action_log_level; }
  
  const std::string& getSendLogFN() const { return send_log_fn; }
  const std::string& getRecvLogFN() const { return recv_log_fn; }

  const std::string& getTrainerSendLogFN() const { return trainer_send_log_fn; }
  const std::string& getTrainerRecvLogFN() const { return trainer_recv_log_fn; }

  RunMode getRunMode() const { return run_mode; }
  
  const std::string& getOnlineHost() const { return online_host; }
  int getOnlinePort() const { return online_port; }
  int getOnlineTrainerPort() const { return online_trainer_port; }
  int getOnlineMaxTimeWOutMsg() const { return online_max_time_wout_msg; }

  const std::string& getTeamName() const { return team_name; }
  const std::string& getCoachName() const { return coach_name; }
  double getServerProtocolVersion() const { return server_protocol_version; }
  
  bool getCreateCommandLog() const { return create_command_log; }
  const std::string& getCommandLogFN() const { return command_log_fn; }

  const std::string& getLogfileFN() const { return logfile_fn; }
  const std::string& getLogfileSideToAnalyze() const { return logfile_side_to_analyze; }
  const std::string& getLogfileTeamToAnalyze() const { return logfile_team_to_analyze; }
  
  int getCyclesToStore() const { return cycles_to_store; }

  bool getUseModTest() const { return use_mod_test; }

  bool getUseModCMRep() const { return use_mod_cmrep; }
  const std::string& getInitialMessagesFN() const { return initial_messages_fn; }
  int getInitMessagesDelay() const { return init_messages_delay; }
  int getMinPlayersBeforeSay() const { return min_players_before_say; }
  int getMaxSayLength() const { return max_say_length; }
  int getMaxSaysPerCycle() const { return max_says_per_cycle; }
  int getSayFrequency() const { return say_frequency; }
  
  bool getUseModFormation() const { return use_mod_formation; }
  double getFormationPointWeight() const { return formation_point_weight; }
  int getFormationREMaxSteps() const { return formation_re_max_steps; }
  double getFormationREStDev() const { return formation_re_stdev; }
  int getFormationHCMaxSteps() const { return formation_hc_max_steps; }
  double getFormationHCLRate() const { return formation_hc_lrate; }
  bool getFormationUseRandom() const { return formation_use_random; }
  bool getFormationLearn() const { return formation_learn; }
  const std::string& getFormationSideToLearn() const { return formation_side_to_learn; }
  const std::string& getFormationTeamToLearn() const { return formation_team_to_learn; }
  int getFormationLearnSampleStep() const { return formation_learn_sample_step; }
  const std::string& getFormationLearnOutputFN() const { return formation_learn_output_fn; }
  bool getFormationCombineData() const { return formation_combine_data; }
  const std::string& getFormationLearnDataFN() const { return formation_learn_data_fn; }
  const std::string& getFormationOppFormFN() const { return formation_opp_form_fn; }
  bool getFormationGatherData() const { return formation_gather_data; }
  bool getFormationSendForm() const { return formation_send_form; }
  bool getFormationSendMarks() const { return formation_send_marks; }
  const std::string& getFormationListFN() const { return formation_list_fn; }
  const std::vector<int>& getFormationNumPerAdaptStyle() const { return formation_num_per_adapt_style; }
  const std::vector<std::string>& getFormationFormatters() const { return formation_formatters; }
  bool getFormationDraw() const { return formation_draw; }
  const std::string& getFormationDrawOutputDir() const { return formation_draw_output_dir; }

  double getTeamMinKickSpeed() const { return team_min_kick_speed; }
  double getTeamAvgKickSpeed() const { return team_avg_kick_speed; }
  double getTeamMaxKickSpeed() const { return team_max_kick_speed; }
  int    getTeamMinTimeTurnWhenGoing() const { return team_min_time_turn_when_going; }
  int    getTeamMinCyclesToKick() const { return team_min_cycles_to_kick; }
  int    getTeamAvgCyclesToKick() const { return team_avg_cycles_to_kick; }
  int    getTeamMaxCyclesToKick() const { return team_max_cycles_to_kick; }

  bool getUseModSetplayPlan() const { return use_mod_setplay_plan; }

  int getSppPlannerType() const { return spp_planner_type; }
  double getSppOffsideWorryDist() const { return spp_offside_worry_dist  ; }
  double getSppOffsetPercSpeed() const { return spp_offset_perc_speed ; }
  int getSppOffsetDelay() const { return spp_offset_delay; }

  bool getSppReuseAgents() const { return spp_reuse_agents; }

  int getSppHillclimbMaxStatSteps() const { return spp_hillclimb_max_stat_steps; }
  int getSppHillclimbMaxSteps() const { return spp_hillclimb_max_steps; }
  int getSppHillclimbResampleFreq() const { return spp_hillclimb_resample_freq; }
  bool getSppHillclimb() const { return spp_hillclimb; }
  bool getSppHillclimbAlwaysFirst() const { return spp_hillclimb_always_first; }
  
  double getSppPotCellLength() const { return spp_pot_cell_length; }
  double getSppPotCellWidth() const { return spp_pot_cell_width; }
  int getSppPotMaxLevels() const { return spp_pot_max_levels; }
  int getSppPotMaxNeigh() const { return spp_pot_max_neigh; }
  double getSppPotPassIncr() const { return spp_pot_pass_incr; }

  double getSppEvalLocWeight() const { return spp_eval_loc_weight; }
  double getSppEvalBadWpWeight() const { return spp_eval_bad_wp_weight; }
  double getSppEvalLengthWeight() const { return spp_eval_length_weight; }
  double getSppEvalPassWeight() const { return spp_eval_pass_weight; }
  double getSppEvalAvgOccWeight() const { return spp_eval_avg_occ_weight; }
  double getSppEvalMaxOccWeight() const { return spp_eval_max_occ_weight; }
  double getSppEvalSampleDensity() const { return spp_eval_sample_density; }
  double getSppEvalSampleWdRatio() const { return spp_eval_sample_wd_ratio; }
  double getSppEvalSampleExtraLen() const { return spp_eval_sample_extra_len; }
  double getSppEvalSendBaseMax() const { return spp_eval_send_base_max; }
  double getSppEvalSendPenMax() const { return spp_eval_send_pen_max; }
  double getSppEvalOffplayPercSpeed() const { return spp_eval_offplay_perc_speed; }
  int getSppEvalOffplayDelay() const { return spp_eval_offplay_delay; }
  double getSppEvalOppDelay() const { return spp_eval_opp_delay; }
  double getSppEvalOppSpeed() const { return spp_eval_opp_speed; }

  const std::string& getSppPlansDir() const { return spp_plans_dir; }
  const std::string& getSppDefMyKickOff1() const { return spp_def_my_kick_off1; }
  const std::string& getSppDefMyKickOff2() const { return spp_def_my_kick_off2; }
  const std::string& getSppDefMyKickIn1() const { return spp_def_my_kick_in1; }
  const std::string& getSppDefMyKickIn2() const { return spp_def_my_kick_in2; }
  const std::string& getSppDefMyCornerKick1() const { return spp_def_my_corner_kick1; }
  const std::string& getSppDefMyCornerKick2() const { return spp_def_my_corner_kick2; }
  const std::string& getSppDefMyGoalKick1() const { return spp_def_my_goal_kick1; }
  const std::string& getSppDefMyGoalKick2() const { return spp_def_my_goal_kick2; }
  const std::string& getSppDefMyFreeKick1() const { return spp_def_my_free_kick1; }
  const std::string& getSppDefMyFreeKick2() const { return spp_def_my_free_kick2; }
  const std::string& getSppDefMyGoalieCatch1() const { return spp_def_my_goalie_catch1; }
  const std::string& getSppDefMyGoalieCatch2() const { return spp_def_my_goalie_catch2; }
  const std::string& getSppDefTheirKickOff() const { return spp_def_their_kick_off; }
  const std::string& getSppDefTheirKickIn() const { return spp_def_their_kick_in; }
  const std::string& getSppDefTheirCornerKick() const { return spp_def_their_corner_kick; }
  const std::string& getSppDefTheirGoalKick() const { return spp_def_their_goal_kick; }
  const std::string& getSppDefTheirFreeKick() const { return spp_def_their_free_kick; }
  const std::string& getSppDefTheirGoalieCatch() const { return spp_def_their_goalie_catch; }

  int getSppMinObsTime() const { return spp_min_obs_time; }
  bool getSppObsOnLostBall() const { return spp_obs_on_lost_ball; }

  bool getSppDrawWaypoints() const { return spp_draw_waypoints; }

  int getSppMaxCoachWait() const { return spp_max_coach_wait; }
  int getSppDelay() const { return spp_delay; }
  int getSppMaxDelay() const { return spp_max_delay; }
  int getSppMaxPlayerSetup() const { return spp_max_player_setup; }
  int getSppMaxPlayerSetupForGC() const { return spp_max_player_setup_for_gc; }
  int getSppTimeLimit() const { return spp_time_limit; }
  int getSppKickoffFixedPosTime() const { return spp_kickoff_fixed_pos_time; }
  int getSppAtPointBuffer() const { return spp_at_point_buffer; }
  double getSppKickDirAngBuffer() const { return spp_kick_dir_ang_buffer; }
  double getSppKickCompleteDist() const { return spp_kick_complete_dist; }
  double getSppMinGotoDist() const { return spp_min_goto_dist; }
  double getSppKickableBuffer() const { return spp_kickable_buffer; }
  int getSppUseBpiCycDiff() const { return spp_use_bpi_cyc_diff; }
  double getSppMinDribbleDist() const { return spp_min_dribble_dist; }
  int getSppMaxOppControlTime() const { return spp_max_opp_control_time; }
  double getSppMinPassConf() const { return spp_min_pass_conf; }
  double getSppMinPassProb() const { return spp_min_pass_prob; }
  bool getSppPassWatchForOthers() const { return spp_pass_watch_for_others; }
  int getSppCoachWaitBuffer() const { return spp_coach_wait_buffer; }
  int getSppPlayerCoachWaitBuffer() const { return spp_player_coach_wait_buffer; }
  int getSppCoachDefaultPlanTime() const { return spp_coach_default_plan_time; }
  bool getSppPlayersReplaceNums() const { return spp_players_replace_nums; }
  int getSppUseActiveCycles() const { return spp_use_active_cycles; }
  double getSppDistToEndForCk() const { return spp_dist_to_end_for_ck; }
  int getSppCyclesToKickBuffer() const { return spp_cycles_to_kick_buffer; }
  double getSppGkStartBuffer() const { return spp_gk_start_buffer; }
  int getSppSendMode() const { return spp_send_mode; }
  double getSppOffDashPow() const { return spp_off_dash_pow; }
  double getSppDefDashPow() const { return spp_def_dash_pow; }

  double getSppForbidAreaBuffer() const { return spp_forbid_area_buffer; }
  double getSppSidelineBuffer() const { return spp_sideline_buffer; }

  double getSppMinPassDist() const { return spp_min_pass_dist; }
  double getSppMaxPassDist() const { return spp_max_pass_dist; }
  double getSppMaxSendDist() const { return spp_max_send_dist; }

  double getSppFracToFocusBest() const { return spp_frac_to_focus_best; }
  int getSppHillclimbNumPaths() const { return spp_hillclimb_num_paths; }
  int getSppHillclimbMinLen() const { return spp_hillclimb_min_len; }
  int getSppHillclimbMaxLen() const { return spp_hillclimb_max_len; }
  const std::string& getSppHillclimbDefFile() const { return spp_hillclimb_def_file; }

  int getSppBaseValidTime() const { return spp_base_valid_time; }
  double getSppPositionBuffer() const { return spp_position_buffer; }

  double getSppPassTargetSpeed() const { return spp_pass_target_speed; }

  bool getSppDrawPlannedWaypoints() const { return spp_draw_planned_waypoints; }
  int getSppDrawPlannedWaypointsScale() const { return spp_draw_planned_waypoints_scale; }
  const std::string& getSppDrawPlannedWaypointsFStem() const { return spp_draw_planned_waypoints_fstem; }

  int getSppUnumMoveForKickoff() const { return spp_unum_move_for_kickoff; }

  // set-play opponent model param
  double getSppOmWeightBoost() const { return spp_om_weight_boost; }

  const std::string& getSppOmSideToAnalyze() const { return spp_om_side_to_analyze; }
  const std::string& getSppOmTeamToAnalyze() const { return spp_om_team_to_analyze; }
  
  const std::string& getSppOmOppModelSetFN() const { return spp_om_opp_model_set_fn; }

  const std::string& getSppOmWeightOutputFN() const { return spp_om_weight_output_fn; }
  const std::string& getSppOmDistOutputFN() const { return spp_om_dist_output_fn; }

  int getSppOmPlayerDelay() const { return spp_om_player_delay; }

  const std::string& getSppOmCalcProbCorrectFN() const { return spp_om_calc_prob_correct_fn; }
  int getSppOmProbCorrectSamplesMax() const { return spp_om_prob_correct_samples_max; }
  int getSppOmProbCorrectSamplesStep() const { return spp_om_prob_correct_samples_step; }
  int getSppOmProbCorrectNumReps() const { return spp_om_prob_correct_num_reps; }
  
  int getSppOmObsInterval() const { return spp_om_obs_interval; }
  int getSppOmMaxBallSteps() const { return spp_om_max_ball_steps; }
  double getSppOmGridCellWidth() const { return spp_om_grid_cell_width; }
  double getSppOmGridCellHeight() const { return spp_om_grid_cell_height; }
  int getSppOmNumModels() const { return spp_om_num_models; }
  double getSppOmMaxPlayerDist() const { return spp_om_max_player_dist; }

  int getSppOmNumExits() const { return spp_om_num_exits; }
  bool getSppOmUseWeights() const { return spp_om_use_weights; }

  // defensive set players
  bool getDspUseDefSetPlays() const { return dsp_use_def_set_plays; }
  double getDspDefSamePosBuffer() const { return dsp_def_same_pos_buffer; }
  
  int getDspNumGkDefinites() const { return dsp_num_gk_definites; }
  int getDspNumFkDefinites() const { return dsp_num_fk_definites; }
  int getDspNumKiDefinites() const { return dsp_num_ki_definites; }
  int getDspNumKoDefinites() const { return dsp_num_ko_definites; }
  int getDspNumGcDefinites() const { return dsp_num_gc_definites; }
  int getDspNumCkDefinites() const { return dsp_num_ck_definites; }

  int getDspNumGkExits() const { return dsp_num_gk_exits; }
  int getDspNumFkExits() const { return dsp_num_fk_exits; }
  int getDspNumKiExits() const { return dsp_num_ki_exits; }
  int getDspNumKoExits() const { return dsp_num_ko_exits; }
  int getDspNumGcExits() const { return dsp_num_gc_exits; }
  int getDspNumCkExits() const { return dsp_num_ck_exits; }

  int getDspNumDefKiExtra() const { return dsp_num_def_ki_extra; }

  bool getUseModStatImage() const { return use_mod_stat_image; }
  bool getModStatDrawWorldState() const { return mod_stat_draw_world_state; }
  int getModStatWorldStateScale() const { return mod_stat_world_state_scale; }
  const std::string& getModStatWorldStateFStem() const { return mod_stat_world_state_fstem; }
  int getModStatWorldStateInterval() const { return mod_stat_world_state_interval; }
  bool getModStatDrawBallPath() const { return mod_stat_draw_ball_path; }
  int getModStatBallPathScale() const { return mod_stat_ball_path_scale; }
  const std::string& getModStatBallPathFStem() const { return mod_stat_ball_path_fstem; }
  int getModStatBallPathRefreshInterval() const { return mod_stat_ball_path_refresh_interval; }
  int getModStatBallPathSampleInterval() const { return mod_stat_ball_path_sample_interval; }
  bool getModStatBallPathUseRec() const { return mod_stat_ball_path_use_rec; }
  const std::vector<double>& getModStatBallPathRecCorners() const { return mod_stat_ball_path_rec_corners; }
  bool getModStatBallPathRecUseColors() const { return mod_stat_ball_path_rec_use_colors; }
  const std::string& getModStatBallPathOwnerSide() const { return mod_stat_ball_path_owner_side; }
  bool getModStatDoMisc() const { return mod_stat_do_misc; }
  const std::string& getModStatMiscOutFN() const { return mod_stat_misc_out_fn; }
  int getModStatMinControlLength() const { return mod_stat_min_control_length; }
  const std::vector<double>& getModStatMiscBallRec() const { return mod_stat_misc_ball_rec; }
  const std::string& getModStatMiscBallInRecXFN() const { return mod_stat_misc_ball_in_rec_x_fn; }

  bool getUseModAbstract() const { return use_mod_abstract; }

  bool getAbstractSendBallKickableFilter() const { return abstract_send_ball_kickable_filter; }
  double getAbstractBallKickableFilterBuffer() const { return abstract_ball_kickable_filter_buffer; }

  bool getAbstractTrackPO() const { return abstract_track_po; }
  const std::string& getAbstractTrackPOSetFN() const { return abstract_track_po_set_fn; }
  bool getAbstractTrackPOWritePerCycle() const { return abstract_track_po_write_per_cycle; }
  const std::string& getAbstractTrackPOPerCycleFN() const { return abstract_track_po_per_cycle_fn; }
  bool getAbstractTrackPOWriteSumm() const { return abstract_track_po_write_summ; }
  const std::string& getAbstractTrackPOSummFN() const { return abstract_track_po_summ_fn; }
  bool getAbstractTrackPOOnlyPlayOn() const { return abstract_track_po_only_play_on; }
  bool getAbstractTrackPoOnlyKickable() const { return abstract_track_po_only_kickable; }
  bool getAbstractTrackPOBothTeams() const { return abstract_track_po_both_teams; }

  bool getAbstractDrawPOSet() const { return abstract_draw_poset; }
  const std::string& getAbstractDrawPOSetInFN() const { return abstract_draw_poset_in_fn; }
  int getAbstractDrawPOSetStateNum() const { return abstract_draw_poset_state_num; }

  bool getAbstractStateTrack() const { return abstract_state_track; }
  const std::string& getAbstractStatePOSetFN() const { return abstract_state_poset_fn; }
  int getAbstractStateBallNumXBins() const { return abstract_state_ball_num_x_bins; }
  int getAbstractStateBallNumYBins() const { return abstract_state_ball_num_y_bins; }
  bool getAbstractStateTrackWriteSumm() const { return abstract_state_track_write_summ; }
  const std::string& getAbstractStateTrackSummFN() const { return abstract_state_track_summ_fn; }
  bool getAbstractStateTrackWritePerCycle() const { return abstract_state_track_write_per_cycle; }
  const std::string& getAbstractStateTrackPerCycleFN() const { return abstract_state_track_per_cycle_fn; }
  bool getAbstractStateTrackBothTeams() const { return abstract_state_track_both_teams; }
  
  bool getAbstractLearnMarkovChain() const { return abstract_learn_markov_chain; }
  const std::string& getAbstractLearnMarkovChainInFN() const { return abstract_learn_markov_chain_in_fn; }
  const std::string& getAbstractLearnMarkovChainOutFN() const { return abstract_learn_markov_chain_out_fn; }
  const std::string& getAbstractLearnMarkovChainNewStatesFN() const { return abstract_learn_markov_chain_new_states_fn; }
  const std::string& getAbstractLearnMarkovChainNewTranFN() const { return abstract_learn_markov_chain_new_tran_fn; }
  int getAbstractLearnMarkovChainStates() const { return abstract_learn_markov_chain_states; }

  bool getAbstractLearnMCV() const { return abstract_learn_mcv; }
  const std::string& getAbstractLearnMCVChainFN() const { return abstract_learn_mcv_chain_fn; }
  const std::string& getAbstractLearnMCVInValueFN() const { return abstract_learn_mcv_in_value_fn; }
  const std::string& getAbstractLearnMCVOutValueFN() const { return abstract_learn_mcv_out_value_fn; }
  int getAbstractLearnMCVProgressInterval() const { return abstract_learn_mcv_progress_interval; }
  double getAbstractLearnMCVTotalChangeLim() const { return abstract_learn_mcv_total_change_lim; }
  double getAbstractLearnMCVPerCapChangeLim() const { return abstract_learn_mcv_per_cap_change_lim; }
  int getAbstractLearnMCVIterLim() const { return abstract_learn_mcv_iter_lim; }
  double getAbstractLearnMCVDiscountFactor() const { return abstract_learn_mcv_discount_factor; }

  bool getAbstractPruneMC() const { return abstract_prune_mc; }
  const std::string& getAbstractPruneMCInFN() const { return abstract_prune_mc_in_fn; }
  const std::string& getAbstractPruneMCOutFN() const { return abstract_prune_mc_out_fn; }
  int getAbstractPruneMCNukeSelfMin() const { return abstract_prune_mc_nuke_self_min; }
  int getAbstractPruneMCNukeSelfMax() const { return abstract_prune_mc_nuke_self_max; }
  int getAbstractPruneMCTargetState() const { return abstract_prune_mc_target_state; }
  const std::string& getAbstractPruneMCTranFN() const { return abstract_prune_mc_tran_fn; }
  
  bool getAbstractMCCreateGraph() const { return abstract_mc_create_graph; }
  const std::string& getAbstractMCGraphChainFN() const { return abstract_mc_graph_chain_fn; }
  const std::string& getAbstractMCGraphValueFN() const { return abstract_mc_graph_value_fn; }
  const std::string& getAbstractMCGraphTreeValueFN() const { return abstract_mc_graph_tree_value_fn; }
  const std::string& getAbstractMCGraphOutGraphFN() const { return abstract_mc_graph_out_graph_fn; }
  const std::string& getAbstractMCGraphName() const { return abstract_mc_graph_name; }
  int getAbstractMCGraphRootState() const { return abstract_mc_graph_root_state; }

  bool getAbstractMCCalcDist() const { return abstract_mc_calc_dist; }
  int getAbstractMCCalcDistTargetState() const { return abstract_mc_calc_dist_target_state; }
  const std::string& getAbstractMCCalcDistChainFN() const { return abstract_mc_calc_dist_chain_fn; }
  const std::string& getAbstractMCCalcDistValueFN() const { return abstract_mc_calc_dist_value_fn; }

  bool getAbstractDrawStates() const { return abstract_draw_states; }
  int getAbstractDrawStateNum() const { return abstract_draw_state_num; }
  const std::string& getAbstractDrawStateCycleFN() const { return abstract_draw_state_cycle_fn; }
  const std::string& getAbstractDrawStateOutFPat() const { return abstract_draw_state_out_fpat; }
  double getAbstractDrawScale() const { return abstract_draw_scale; }
  int getAbstractDrawLegendLines() const { return abstract_draw_legend_lines; }

  bool getAbstractClassifyMC() const { return abstract_classify_mc; }
  const std::string& getAbstractClassifyMCInMCFN() const { return abstract_classify_mc_in_mc_fn; }
  const std::string& getAbstractClassifyMCInASDCSetFN() const { return abstract_classify_mc_in_asdcset_fn; }
  const std::string& getAbstractClassifyMCOutFullFN() const { return abstract_classify_mc_out_full_fn; }
  const std::string& getAbstractClassifyMCOutSummFN() const { return abstract_classify_mc_out_summ_fn; }

  bool getAbstractConvertMDP() const { return abstract_convert_mdp; }
  const std::string& getAbstractConvertMDPInMCFN() const { return abstract_convert_mdp_in_mc_fn; }
  const std::string& getAbstractConvertMDPInASDCSetFN() const { return abstract_convert_mdp_in_asdcset_fn; }
  const std::string& getAbstractConvertMDPInTSortFN() const { return abstract_convert_mdp_in_tsort_fn; }
  const std::string& getAbstractConvertMDPOutMDPFN() const { return abstract_convert_mdp_out_mdp_fn; }

  bool getAbstractSolveMDP() const { return abstract_solve_mdp; }
  const std::string& getAbstractSolveMDPInMDPFN() const { return abstract_solve_mdp_in_mdp_fn; }
  const std::string& getAbstractSolveMDPOutQTFN() const { return abstract_solve_mdp_out_qt_fn; }
  double getAbstractSolveMDPGamma() const { return abstract_solve_mdp_gamma; }

  bool getAbstractShowMDPState() const { return abstract_show_mdp_state; }
  const std::string& getAbstractShowMDPStateMDPFN() const { return abstract_show_mdp_state_mdp_fn; }
  int getAbstractShowMDPStateNum() const { return abstract_show_mdp_state_num; }

  bool getAbstractAdviceByMDP() const { return abstract_advice_by_mdp; }
  const std::string& getAbstractABMDPFN() const { return abstract_abmdp_fn; }
  const std::string& getAbstractABMDPQTableFN() const { return abstract_abmdp_qtable_fn; }
  double getAbstractABMDPPercOpt() const { return abstract_abmdp_perc_opt; }
  bool getAbstractABMDPChooseWorstActions() const { return abstract_abmdp_choose_worst_actions; }
  bool getAbstractABMDPSendAdvice() const { return abstract_abmdp_send_advice; }
  const std::string& getAbstractABMDPRankFilterFN() const { return abstract_abmdp_rank_filter_fn; }
  int getAbstractABMDPRankFilterCount() const { return abstract_abmdp_rank_filter_count; }
  bool getAbstractABMDPRankFilterFromTop() const { return abstract_abmdp_rank_filter_from_top; }
  const std::string& getAbstractABMDPValueFilterFN() const { return abstract_abmdp_value_filter_fn; }
  double getAbstractABMDPValueFilterMin() const { return abstract_abmdp_value_filter_min; }
  double getAbstractABMDPValueFilterMax() const { return abstract_abmdp_value_filter_max; }
  bool getAbstractABMDPUseAdviceTree() const { return abstract_abmdp_use_advice_tree; }
  bool getAbstractABMDPAdviceTreeShuffle() const { return abstract_abmdp_advice_tree_shuffle; }
  bool getAbstractABMDPCreateTreeAssoc() const { return abstract_abmdp_create_tree_assoc; }
  const std::string& getAbstractABMDPTreeAssocFN() const { return abstract_abmdp_tree_assoc_fn; }
  bool getAbstractABMDPTrack() const { return abstract_abmdp_track; }
  const std::string& getAbstractABMDPTrackFN() const { return abstract_abmdp_track_fn; }
  bool getAbstractABMDPUseBackChannel() const { return abstract_abmdp_use_back_channel; }
  const std::string& getAbstractABMDPBackChannelFN() const { return abstract_abmdp_back_channel_fn; }

  int getAbstractABMDPMultiCount() const { return abstract_abmdp_multi_count; }
  const std::vector<std::string>& getAbstractABMDPMultiPOSetFN() const { return abstract_abmdp_multi_poset_fn; }
  const std::vector<std::string>& getAbstractABMDPMultiMDPFN() const { return abstract_abmdp_multi_mdp_fn; }
  const std::vector<std::string>& getAbstractABMDPMultiQTableFN() const { return abstract_abmdp_multi_qtable_fn; }
  const std::string& getAbstractABMDPMultiTreeAssocFPat() const { return abstract_abmdp_multi_tree_assoc_fpat; }
  const std::vector<int>& getAbstractABMDPMultiStratToMDPIdx() const { return abstract_abmdp_multi_strat_to_mdp_idx; }

  bool getAbstractMDPGeneratePassPosAdvice() const { return abstract_mdp_generate_pass_pos_advice; }
  double getAbstractMDPPassExpandYInt() const { return abstract_mdp_pass_expand_y_int; }
  double getAbstractMDPPassExpandSlope() const { return abstract_mdp_pass_expand_slope; }
  
  bool getAbstractAnalyzeQTable() const { return abstract_analyze_qtable; }
  const std::string& getAbstractAnalyzeQTableFN() const { return abstract_analyze_qtable_fn; }
  const std::string& getAbstractAnalyzeQTableOutSvMaxFN() const { return abstract_analyze_qtable_out_sv_max_fn; }
  const std::string& getAbstractAnalyzeQTableOutSvRangeFN() const  { return abstract_analyze_qtable_out_sv_range_fn; }

  bool getAbstractCompareStateTraceToModel() const { return abstract_compare_state_trace_to_model; }
  const std::string& getAbstractCompareST2MInListFN() const { return abstract_compare_st2m_in_list_fn; }
  int getAbstractCompareSt2mIgnoreSelfTranMin() const { return abstract_compare_st2m_ignore_self_tran_min; }
  int getAbstractCompareSt2mIgnoreSelfTranMax() const { return abstract_compare_st2m_ignore_self_tran_max; }
  
  bool getAbstractComputeAvgReward() const { return abstract_compute_avg_reward; }
  int getAbstractComputeARStartState() const { return abstract_compute_ar_start_state; }
  int getAbstractComputeARNumSteps() const { return abstract_compute_ar_num_steps; }
  int getAbstractComputeARNumReps() const { return abstract_compute_ar_num_reps; }

  bool getAbstractAnalyzeMDP() const { return abstract_analyze_mdp; }
  const std::string& getAbstractAnalyzeMDPInFN() const { return abstract_analyze_mdp_in_fn; }

  bool getAbstractGenerateMDPTraces() const { return abstract_generate_mdp_traces; }
  int getAbstractGenerateMDPTracesCount() const { return abstract_generate_mdp_traces_count; }
  int getAbstractGenerateMDPTracesSteps() const { return abstract_generate_mdp_traces_steps; }
  const std::string& getAbstractGenerateMDPTracesOutFN() const { return abstract_generate_mdp_traces_out_fn; }
  bool getAbstractGenerateMDPTracesUseMax() const { return abstract_generate_mdp_traces_use_max; }
  
  bool getAbstractConvertToBinary() const { return abstract_convert_to_binary; }
  const std::string& getAbstractConvertQTableInFN() const { return abstract_convert_qtable_in_fn; }
  const std::string& getAbstractConvertQTableOutFN() const { return abstract_convert_qtable_out_fn; }
  const std::string& getAbstractConvertMDPInFN() const { return abstract_convert_mdp_in_fn; }
  const std::string& getAbstractConvertMDPOutFN() const { return abstract_convert_mdp_out_fn; }

  bool getAbstractAnalyzePercentOptimal() const { return abstract_analyze_percent_optimal; }
  const std::vector<double>& getAbstractAnalyzePercentOptimalValues() const { return abstract_analyze_percent_optimal_values; }
  const std::string& getAbstractAnalyzePercentOptimalOutDir() const { return abstract_analyze_percent_optimal_out_dir; }
  
  bool getUseModFeatures() const { return use_mod_features; }
  int getFeaturesCyclesToStore() const { return features_cycles_to_store; }
  bool getFeaturesCreateBallOwnerLog() const { return features_create_ball_owner_log; }
  const std::string& getFeaturesBallOwnerLogFN() const { return features_ball_owner_log_fn; }
  bool getFeaturesCreateBallPossessLog() const { return features_create_ball_possess_log; }
  const std::string& getFeaturesBallPossessLogFN() const { return features_ball_possess_log_fn; }

  bool getUseModTrainer() const { return use_mod_trainer; }
  int getTrainerDropBallInterval() const { return trainer_drop_ball_interval; }
  const std::string& getTrainerDropBallSpotsFN() const { return trainer_drop_ball_spots_fn; }

  bool getUseModGlobalAdapt() const { return use_mod_global_adapt; }
  bool getGlobalAdaptReadResults() const { return global_adapt_read_results; }
  const std::string& getGlobalAdaptInResultsFN() const { return global_adapt_in_results_fn; }
  bool getGlobalAdaptWriteResults() const { return global_adapt_write_results; }
  const std::string& getGlobalAdaptOutResultsFN() const { return global_adapt_out_results_fn; }
  bool getGlobalAdaptAppend() const { return global_adapt_append; }
  const std::string& getGlobalAdaptInitialStrategyStyle() const { return global_adapt_initial_strategy_style; }
  int getGlobalAdaptInitialStrategyIndex() const { return global_adapt_initial_strategy_index; }
  int getGlobalAdaptAdjustInterval() const { return global_adapt_adjust_interval; }
  bool getGlobalAdaptAdjustAfterGoals() const { return global_adapt_adjust_after_goals; }
  bool getGlobalAdaptAdjustAtStoppage() const { return global_adapt_adjust_at_stoppage; }
  bool getGlobalAdaptUseFixedAdvice() const { return global_adapt_use_fixed_advice; }
  const std::string& getGlobalAdaptFixedAdviceMapFN() const { return global_adapt_fixed_advice_map_fn; }
  int getGlobalAdaptGoodDataAmtThreshold() const { return global_adapt_good_data_amt_threshold; }

protected:

  std::string logfile_dir;
  std::string action_log_fn;
  int action_log_level;

  std::string send_log_fn;
  std::string recv_log_fn;
  
  std::string trainer_send_log_fn;
  std::string trainer_recv_log_fn;
  
  std::string run_mode_str;
  RunMode run_mode;
  
  std::string online_host;
  int online_port;
  int online_trainer_port;
  int online_max_time_wout_msg;
  
  std::string team_name;
  std::string coach_name;
  double server_protocol_version;

  std::string logfile_fn;
  std::string logfile_side_to_analyze;
  std::string logfile_team_to_analyze;
  
  bool create_command_log;
  std::string command_log_fn;

  int cycles_to_store;

  bool use_mod_test;

  bool use_mod_cmrep;
  std::string initial_messages_fn;
  int init_messages_delay;
  int min_players_before_say;
  int max_say_length;
  int max_says_per_cycle;
  int say_frequency;
  
  bool use_mod_formation;
  double formation_point_weight;
  int formation_re_max_steps;
  double formation_re_stdev;
  int formation_hc_max_steps;
  double formation_hc_lrate;
  bool formation_use_random;
  bool formation_learn;
  std::string formation_side_to_learn;
  std::string formation_team_to_learn;
  int formation_learn_sample_step;
  std::string formation_learn_output_fn;
  bool formation_combine_data;
  std::string formation_learn_data_fn;
  std::string formation_opp_form_fn;
  bool formation_gather_data;
  bool formation_send_form;
  bool formation_send_marks;
  std::string formation_list_fn;
  std::vector<int> formation_num_per_adapt_style;
  std::vector<std::string> formation_formatters;
  bool formation_draw;
  std::string formation_draw_output_dir;
  
  double team_min_kick_speed;
  double team_avg_kick_speed;
  double team_max_kick_speed;
  int    team_min_time_turn_when_going;
  int    team_min_cycles_to_kick;
  int    team_avg_cycles_to_kick;
  int    team_max_cycles_to_kick;
    
  // set-play planning
  bool use_mod_setplay_plan;
  
  int spp_planner_type;
  double spp_offside_worry_dist;  
  double spp_offset_perc_speed; 
  int spp_offset_delay;

  bool spp_reuse_agents;

  int spp_hillclimb_max_stat_steps;
  int spp_hillclimb_max_steps;
  int  spp_hillclimb_resample_freq;
  bool spp_hillclimb; //whether to hillclimb or just choose best
  bool spp_hillclimb_always_first;

  double spp_pot_cell_length;
  double spp_pot_cell_width;
  int   spp_pot_max_levels;
  int   spp_pot_max_neigh;
  double spp_pot_pass_incr;

  double spp_eval_loc_weight;
  double spp_eval_bad_wp_weight;
  double spp_eval_length_weight;
  double spp_eval_pass_weight;
  double spp_eval_avg_occ_weight;
  double spp_eval_max_occ_weight;
  double spp_eval_sample_density;
  double spp_eval_sample_wd_ratio;
  double spp_eval_sample_extra_len;
  double spp_eval_send_base_max;
  double spp_eval_send_pen_max;
  double spp_eval_offplay_perc_speed;
  int   spp_eval_offplay_delay;
  double spp_eval_opp_delay;
  double spp_eval_opp_speed;

  std::string spp_plans_dir;
  std::string spp_def_my_kick_off1;
  std::string spp_def_my_kick_off2;
  std::string spp_def_my_kick_in1;
  std::string spp_def_my_kick_in2;
  std::string spp_def_my_corner_kick1;
  std::string spp_def_my_corner_kick2;
  std::string spp_def_my_goal_kick1;
  std::string spp_def_my_goal_kick2;
  std::string spp_def_my_free_kick1;
  std::string spp_def_my_free_kick2;
  std::string spp_def_my_goalie_catch1;
  std::string spp_def_my_goalie_catch2;
  std::string spp_def_their_kick_off;
  std::string spp_def_their_kick_in;
  std::string spp_def_their_corner_kick;
  std::string spp_def_their_goal_kick;
  std::string spp_def_their_free_kick;
  std::string spp_def_their_goalie_catch;

  int spp_min_obs_time;
  bool spp_obs_on_lost_ball;

  bool spp_draw_waypoints;

  int   spp_max_coach_wait;
  int   spp_delay;
  int   spp_max_delay;
  int   spp_max_player_setup;
  int   spp_max_player_setup_for_gc;
  int   spp_time_limit;
  int   spp_kickoff_fixed_pos_time;
  int   spp_at_point_buffer;
  double spp_kick_dir_ang_buffer;
  double spp_kick_complete_dist;
  double spp_min_goto_dist;
  double spp_kickable_buffer;
  int   spp_use_bpi_cyc_diff;
  double spp_min_dribble_dist;
  int   spp_max_opp_control_time;
  double spp_min_pass_conf;
  double spp_min_pass_prob;
  bool  spp_pass_watch_for_others;
  int   spp_coach_wait_buffer;
  int   spp_player_coach_wait_buffer;
  int   spp_coach_default_plan_time;
  bool  spp_players_replace_nums;
  int   spp_use_active_cycles;
  double spp_dist_to_end_for_ck;
  int   spp_cycles_to_kick_buffer;
  double spp_gk_start_buffer;
  int   spp_send_mode;
  double spp_off_dash_pow;
  double spp_def_dash_pow;

  double spp_forbid_area_buffer;
  double spp_sideline_buffer;

  double spp_min_pass_dist;
  double spp_max_pass_dist;
  double spp_max_send_dist;

  double spp_frac_to_focus_best;
  int spp_hillclimb_num_paths;
  int spp_hillclimb_min_len;
  int spp_hillclimb_max_len;
  std::string spp_hillclimb_def_file;

  int spp_base_valid_time;
  double spp_position_buffer;

  double spp_pass_target_speed;
  
  bool spp_draw_planned_waypoints;
  int spp_draw_planned_waypoints_scale;
  std::string spp_draw_planned_waypoints_fstem;

  int spp_unum_move_for_kickoff;
  
  // Opponent Model params
  double spp_om_weight_boost;

  std::string spp_om_side_to_analyze;
  std::string spp_om_team_to_analyze;
  
  std::string spp_om_opp_model_set_fn;

  std::string spp_om_weight_output_fn;
  std::string spp_om_dist_output_fn;

  int spp_om_player_delay;

  std::string spp_om_calc_prob_correct_fn;
  int  spp_om_prob_correct_samples_max;
  int  spp_om_prob_correct_samples_step;
  int  spp_om_prob_correct_num_reps;

  int spp_om_obs_interval;
  int spp_om_max_ball_steps;
  double spp_om_grid_cell_width;
  double spp_om_grid_cell_height;
  int spp_om_num_models;
  double spp_om_max_player_dist;

  int spp_om_num_exits;
  bool spp_om_use_weights;

  // defensive set players
  bool dsp_use_def_set_plays;
  double dsp_def_same_pos_buffer;
  
  int dsp_num_gk_definites;
  int dsp_num_fk_definites;
  int dsp_num_ki_definites;
  int dsp_num_ko_definites;
  int dsp_num_gc_definites;
  int dsp_num_ck_definites;

  int dsp_num_gk_exits;
  int dsp_num_fk_exits;
  int dsp_num_ki_exits;
  int dsp_num_ko_exits;
  int dsp_num_gc_exits;
  int dsp_num_ck_exits;

  int dsp_num_def_ki_extra;

  bool use_mod_stat_image;
  bool mod_stat_draw_world_state;
  int  mod_stat_world_state_scale;
  std::string mod_stat_world_state_fstem;
  int  mod_stat_world_state_interval;
  bool mod_stat_draw_ball_path;
  int  mod_stat_ball_path_scale;
  std::string mod_stat_ball_path_fstem;
  int  mod_stat_ball_path_refresh_interval;
  int  mod_stat_ball_path_sample_interval;
  bool mod_stat_ball_path_use_rec;
  std::vector<double> mod_stat_ball_path_rec_corners;
  bool mod_stat_ball_path_rec_use_colors;
  std::string mod_stat_ball_path_owner_side;
  bool mod_stat_do_misc;
  std::string mod_stat_misc_out_fn;
  int mod_stat_min_control_length;
  std::vector<double> mod_stat_misc_ball_rec;
  std::string mod_stat_misc_ball_in_rec_x_fn;
  
  bool use_mod_abstract;

  bool abstract_send_ball_kickable_filter;
  double abstract_ball_kickable_filter_buffer;
  
  bool abstract_track_po;
  std::string abstract_track_po_set_fn;
  bool abstract_track_po_write_per_cycle;
  std::string abstract_track_po_per_cycle_fn;
  bool abstract_track_po_write_summ;
  std::string abstract_track_po_summ_fn;
  bool abstract_track_po_only_play_on;
  bool abstract_track_po_only_kickable;
  bool abstract_track_po_both_teams;

  bool abstract_draw_poset;
  std::string abstract_draw_poset_in_fn;
  int abstract_draw_poset_state_num;

  bool abstract_state_track;
  std::string abstract_state_poset_fn;
  int abstract_state_ball_num_x_bins;
  int abstract_state_ball_num_y_bins;
  bool abstract_state_track_write_summ;
  std::string abstract_state_track_summ_fn;
  bool abstract_state_track_write_per_cycle;
  std::string abstract_state_track_per_cycle_fn;
  bool abstract_state_track_both_teams;

  bool abstract_learn_markov_chain;
  std::string abstract_learn_markov_chain_in_fn;
  std::string abstract_learn_markov_chain_out_fn;
  std::string abstract_learn_markov_chain_new_states_fn;
  std::string abstract_learn_markov_chain_new_tran_fn;
  int abstract_learn_markov_chain_states;

  bool abstract_learn_mcv;
  std::string abstract_learn_mcv_chain_fn;
  std::string abstract_learn_mcv_in_value_fn;
  std::string abstract_learn_mcv_out_value_fn;
  int abstract_learn_mcv_progress_interval;
  double abstract_learn_mcv_total_change_lim;
  double abstract_learn_mcv_per_cap_change_lim;
  int abstract_learn_mcv_iter_lim;
  double abstract_learn_mcv_discount_factor;
  
  bool abstract_prune_mc;
  std::string abstract_prune_mc_in_fn;
  std::string abstract_prune_mc_out_fn;
  int abstract_prune_mc_nuke_self_min;
  int abstract_prune_mc_nuke_self_max;
  int abstract_prune_mc_target_state;
  std::string abstract_prune_mc_tran_fn;
  
  bool abstract_mc_create_graph;
  std::string abstract_mc_graph_chain_fn;
  std::string abstract_mc_graph_value_fn;
  std::string abstract_mc_graph_tree_value_fn;
  std::string abstract_mc_graph_out_graph_fn;
  std::string abstract_mc_graph_name;
  int abstract_mc_graph_root_state;
  
  bool abstract_mc_calc_dist;
  int abstract_mc_calc_dist_target_state;
  std::string abstract_mc_calc_dist_chain_fn;
  std::string abstract_mc_calc_dist_value_fn;

  bool abstract_draw_states;
  int abstract_draw_state_num;
  std::string abstract_draw_state_cycle_fn;
  std::string abstract_draw_state_out_fpat;
  double abstract_draw_scale;
  int abstract_draw_legend_lines;

  bool abstract_classify_mc;
  std::string abstract_classify_mc_in_mc_fn;
  std::string abstract_classify_mc_in_asdcset_fn;
  std::string abstract_classify_mc_out_full_fn;
  std::string abstract_classify_mc_out_summ_fn;

  bool abstract_convert_mdp;
  std::string abstract_convert_mdp_in_mc_fn;
  std::string abstract_convert_mdp_in_asdcset_fn;
  std::string abstract_convert_mdp_in_tsort_fn;
  std::string abstract_convert_mdp_out_mdp_fn;

  bool abstract_solve_mdp;
  std::string abstract_solve_mdp_in_mdp_fn;
  std::string abstract_solve_mdp_out_qt_fn;
  double abstract_solve_mdp_gamma;

  bool abstract_show_mdp_state;
  std::string abstract_show_mdp_state_mdp_fn;
  int abstract_show_mdp_state_num;
  
  bool abstract_advice_by_mdp;
  std::string abstract_abmdp_fn;
  std::string abstract_abmdp_qtable_fn;
  double abstract_abmdp_perc_opt;
  bool abstract_abmdp_choose_worst_actions;
  bool abstract_abmdp_send_advice;
  std::string abstract_abmdp_rank_filter_fn;
  int abstract_abmdp_rank_filter_count;
  bool abstract_abmdp_rank_filter_from_top;
  std::string abstract_abmdp_value_filter_fn;
  double abstract_abmdp_value_filter_min;
  double abstract_abmdp_value_filter_max;
  bool abstract_abmdp_use_advice_tree;
  bool abstract_abmdp_advice_tree_shuffle;
  bool abstract_abmdp_create_tree_assoc;
  std::string abstract_abmdp_tree_assoc_fn;
  bool abstract_abmdp_track;
  std::string abstract_abmdp_track_fn;
  bool abstract_abmdp_use_back_channel;
  std::string abstract_abmdp_back_channel_fn;

  int abstract_abmdp_multi_count;
  std::vector<std::string> abstract_abmdp_multi_poset_fn;
  std::vector<std::string> abstract_abmdp_multi_mdp_fn;
  std::vector<std::string> abstract_abmdp_multi_qtable_fn;
  std::string abstract_abmdp_multi_tree_assoc_fpat;
  std::vector<int> abstract_abmdp_multi_strat_to_mdp_idx;
  
  bool abstract_mdp_generate_pass_pos_advice;
  double abstract_mdp_pass_expand_y_int;
  double abstract_mdp_pass_expand_slope;

  bool abstract_analyze_qtable;
  std::string abstract_analyze_qtable_fn;  
  std::string abstract_analyze_qtable_out_sv_max_fn;
  std::string abstract_analyze_qtable_out_sv_range_fn;

  bool abstract_compare_state_trace_to_model;
  std::string abstract_compare_st2m_in_list_fn;
  int abstract_compare_st2m_ignore_self_tran_min;
  int abstract_compare_st2m_ignore_self_tran_max;

  bool abstract_compute_avg_reward;
  int abstract_compute_ar_start_state;
  int abstract_compute_ar_num_steps;
  int abstract_compute_ar_num_reps;
  
  bool abstract_analyze_mdp;
  std::string abstract_analyze_mdp_in_fn;

  bool abstract_generate_mdp_traces;
  int  abstract_generate_mdp_traces_count;
  int  abstract_generate_mdp_traces_steps;
  std::string  abstract_generate_mdp_traces_out_fn;
  bool abstract_generate_mdp_traces_use_max;

  bool abstract_convert_to_binary;
  std::string abstract_convert_qtable_in_fn;
  std::string abstract_convert_qtable_out_fn;
  std::string abstract_convert_mdp_in_fn;
  std::string abstract_convert_mdp_out_fn;

  bool abstract_analyze_percent_optimal;
  std::vector<double> abstract_analyze_percent_optimal_values;
  std::string abstract_analyze_percent_optimal_out_dir;

  bool use_mod_features;
  int features_cycles_to_store;
  bool features_create_ball_owner_log;
  std::string features_ball_owner_log_fn;
  bool features_create_ball_possess_log;
  std::string features_ball_possess_log_fn;
  
  bool use_mod_trainer;
  int trainer_drop_ball_interval;
  std::string trainer_drop_ball_spots_fn;

  bool use_mod_global_adapt;
  bool global_adapt_read_results;
  std::string global_adapt_in_results_fn;
  bool global_adapt_write_results;
  std::string global_adapt_out_results_fn;
  bool global_adapt_append;
  std::string global_adapt_initial_strategy_style;
  int global_adapt_initial_strategy_index;
  int global_adapt_adjust_interval;
  bool global_adapt_adjust_after_goals;
  bool global_adapt_adjust_at_stoppage;
  bool global_adapt_use_fixed_advice;
  std::string global_adapt_fixed_advice_map_fn;
  int global_adapt_good_data_amt_threshold;
  
};

#endif
