/* -*- Mode: c++ -*- */

#include <sstream>
#include "CoachParam.h"
#include "Logger.h"
#include "version.h"

using namespace spades;

CoachParam* CoachParam::s_instance = NULL;

CoachParam::CoachParam ()
  : PlayerParam()
{
  if (s_instance)
    errorlog << "Should only be one instance of CoachParam" << ende;
  s_instance = this;
}

CoachParam::~CoachParam ()
{
  s_instance = NULL;
}

void
CoachParam::addAll2Maps ()
{
  PlayerParam::addAll2Maps();

  add2Maps ("logfile_dir", &logfile_dir);
  add2Maps ("action_log_fn", &action_log_fn);
  add2Maps ("action_log_level", &action_log_level);

  add2Maps ("send_log_fn", &send_log_fn);  
  add2Maps ("recv_log_fn", &recv_log_fn);

  add2Maps ("trainer_send_log_fn", &trainer_send_log_fn);  
  add2Maps ("trainer_recv_log_fn", &trainer_recv_log_fn);

  add2Maps ("run_mode", &run_mode_str);
  
  add2Maps ("online_host", &online_host);
  add2Maps ("online_port", &online_port);
  add2Maps ("online_trainer_port", &online_trainer_port);
  add2Maps ("online_max_time_wout_msg", &online_max_time_wout_msg);  
  
  add2Maps ("team_name", &team_name);  
  add2Maps ("coach_name", &coach_name);
  add2Maps ("server_protocol_version", &server_protocol_version);

  add2Maps ("create_command_log", &create_command_log);  
  add2Maps ("command_log_fn", &command_log_fn);

  add2Maps ("logfile_fn", &logfile_fn);
  add2Maps ("logfile_side_to_analyze", &logfile_side_to_analyze);
  add2Maps ("logfile_team_to_analyze", &logfile_team_to_analyze);
  
  add2Maps ("cycles_to_store", &cycles_to_store);

  add2Maps ("use_mod_test", &use_mod_test);

  add2Maps ("use_mod_cmrep", &use_mod_cmrep);
  add2Maps ("initial_messages_fn", &initial_messages_fn);
  add2Maps ("init_messages_delay", &init_messages_delay);
  add2Maps ("min_players_before_say", &min_players_before_say);
  add2Maps ("max_say_length", &max_say_length);
  add2Maps ("max_says_per_cycle", &max_says_per_cycle);
  add2Maps ("say_frequency", &say_frequency);

  add2Maps ("use_mod_formation", &use_mod_formation);
  add2Maps ("formation_point_weight", &formation_point_weight);
  add2Maps ("formation_re_max_steps", &formation_re_max_steps);
  add2Maps ("formation_re_stdev", &formation_re_stdev);
  add2Maps ("formation_hc_max_steps", &formation_hc_max_steps);
  add2Maps ("formation_hc_lrate", &formation_hc_lrate);
  add2Maps ("formation_use_random", &formation_use_random);
  add2Maps ("formation_learn", &formation_learn);
  add2Maps ("formation_side_to_learn", &formation_side_to_learn);
  add2Maps ("formation_team_to_learn", &formation_team_to_learn);
  add2Maps ("formation_learn_sample_step", &formation_learn_sample_step);
  add2Maps ("formation_learn_output_fn", &formation_learn_output_fn);
  add2Maps ("formation_combine_data", &formation_combine_data);
  add2Maps ("formation_learn_data_fn", &formation_learn_data_fn);
  add2Maps ("formation_opp_form_fn", &formation_opp_form_fn);
  add2Maps ("formation_gather_data", &formation_gather_data);
  add2Maps ("formation_send_form", &formation_send_form);
  add2Maps ("formation_send_marks", &formation_send_marks);
  add2Maps ("formation_list_fn", &formation_list_fn);
  add2Maps ("formation_num_per_adapt_style", &formation_num_per_adapt_style, 3, 3);
  add2Maps ("formation_formatters", &formation_formatters, 11, 11);
  add2Maps ("formation_draw", &formation_draw);
  add2Maps ("formation_draw_output_dir", &formation_draw_output_dir);

  add2Maps ("team_min_kick_speed", &team_min_kick_speed);
  add2Maps ("team_avg_kick_speed", &team_avg_kick_speed);
  add2Maps ("team_max_kick_speed", &team_max_kick_speed);
  add2Maps ("team_min_time_turn_when_going", &team_min_time_turn_when_going);
  add2Maps ("team_min_cycles_to_kick", &team_min_cycles_to_kick);
  add2Maps ("team_avg_cycles_to_kick", &team_avg_cycles_to_kick);
  add2Maps ("team_max_cycles_to_kick", &team_max_cycles_to_kick);

  add2Maps ("use_mod_setplay_plan", &use_mod_setplay_plan);

  add2Maps ("spp_planner_type", &spp_planner_type);
  add2Maps ("spp_offside_worry_dist", &spp_offside_worry_dist  );
  add2Maps ("spp_offset_perc_speed", &spp_offset_perc_speed );
  add2Maps ("spp_offset_delay", &spp_offset_delay);

  add2Maps ("spp_reuse_agents", &spp_reuse_agents);

  add2Maps ("spp_hillclimb_max_stat_steps", &spp_hillclimb_max_stat_steps);
  add2Maps ("spp_hillclimb_max_steps", &spp_hillclimb_max_steps);
  add2Maps ("spp_hillclimb_resample_freq", &spp_hillclimb_resample_freq);
  add2Maps ("spp_hillclimb", &spp_hillclimb);
  add2Maps ("spp_hillclimb_always_first", &spp_hillclimb_always_first);
  
  add2Maps ("spp_pot_cell_length", &spp_pot_cell_length);
  add2Maps ("spp_pot_cell_width", &spp_pot_cell_width);
  add2Maps ("spp_pot_max_levels", &spp_pot_max_levels);
  add2Maps ("spp_pot_max_neigh", &spp_pot_max_neigh);
  add2Maps ("spp_pot_pass_incr", &spp_pot_pass_incr);

  add2Maps ("spp_eval_loc_weight", &spp_eval_loc_weight);
  add2Maps ("spp_eval_bad_wp_weight", &spp_eval_bad_wp_weight);
  add2Maps ("spp_eval_length_weight", &spp_eval_length_weight);
  add2Maps ("spp_eval_pass_weight", &spp_eval_pass_weight);
  add2Maps ("spp_eval_avg_occ_weight", &spp_eval_avg_occ_weight);
  add2Maps ("spp_eval_max_occ_weight", &spp_eval_max_occ_weight);
  add2Maps ("spp_eval_sample_density", &spp_eval_sample_density);
  add2Maps ("spp_eval_sample_wd_ratio", &spp_eval_sample_wd_ratio);
  add2Maps ("spp_eval_sample_extra_len", &spp_eval_sample_extra_len);
  add2Maps ("spp_eval_send_base_max", &spp_eval_send_base_max);
  add2Maps ("spp_eval_send_pen_max", &spp_eval_send_pen_max);
  add2Maps ("spp_eval_offplay_perc_speed", &spp_eval_offplay_perc_speed);
  add2Maps ("spp_eval_offplay_delay", &spp_eval_offplay_delay);
  add2Maps ("spp_eval_opp_delay", &spp_eval_opp_delay);
  add2Maps ("spp_eval_opp_speed", &spp_eval_opp_speed);

  add2Maps ("spp_plans_dir", &spp_plans_dir);
  add2Maps ("spp_def_my_kick_off1", &spp_def_my_kick_off1);
  add2Maps ("spp_def_my_kick_off2", &spp_def_my_kick_off2);
  add2Maps ("spp_def_my_kick_in1", &spp_def_my_kick_in1);
  add2Maps ("spp_def_my_kick_in2", &spp_def_my_kick_in2);
  add2Maps ("spp_def_my_corner_kick1", &spp_def_my_corner_kick1);
  add2Maps ("spp_def_my_corner_kick2", &spp_def_my_corner_kick2);
  add2Maps ("spp_def_my_goal_kick1", &spp_def_my_goal_kick1);
  add2Maps ("spp_def_my_goal_kick2", &spp_def_my_goal_kick2);
  add2Maps ("spp_def_my_free_kick1", &spp_def_my_free_kick1);
  add2Maps ("spp_def_my_free_kick2", &spp_def_my_free_kick2);
  add2Maps ("spp_def_my_goalie_catch1", &spp_def_my_goalie_catch1);
  add2Maps ("spp_def_my_goalie_catch2", &spp_def_my_goalie_catch2);
  add2Maps ("spp_def_their_kick_off", &spp_def_their_kick_off);
  add2Maps ("spp_def_their_kick_in", &spp_def_their_kick_in);
  add2Maps ("spp_def_their_corner_kick", &spp_def_their_corner_kick);
  add2Maps ("spp_def_their_goal_kick", &spp_def_their_goal_kick);
  add2Maps ("spp_def_their_free_kick", &spp_def_their_free_kick);
  add2Maps ("spp_def_their_goalie_catch", &spp_def_their_goalie_catch);

  add2Maps ("spp_min_obs_time", &spp_min_obs_time);
  add2Maps ("spp_obs_on_lost_ball", &spp_obs_on_lost_ball);

  add2Maps ("spp_draw_waypoints", &spp_draw_waypoints);

  add2Maps ("spp_max_coach_wait", &spp_max_coach_wait);
  add2Maps ("spp_delay", &spp_delay);
  add2Maps ("spp_max_delay", &spp_max_delay);
  add2Maps ("spp_max_player_setup", &spp_max_player_setup);
  add2Maps ("spp_max_player_setup_for_gc", &spp_max_player_setup_for_gc);
  add2Maps ("spp_time_limit", &spp_time_limit);
  add2Maps ("spp_kickoff_fixed_pos_time", &spp_kickoff_fixed_pos_time);
  add2Maps ("spp_at_point_buffer", &spp_at_point_buffer);
  add2Maps ("spp_kick_dir_ang_buffer", &spp_kick_dir_ang_buffer);
  add2Maps ("spp_kick_complete_dist", &spp_kick_complete_dist);
  add2Maps ("spp_min_goto_dist", &spp_min_goto_dist);
  add2Maps ("spp_kickable_buffer", &spp_kickable_buffer);
  add2Maps ("spp_use_bpi_cyc_diff", &spp_use_bpi_cyc_diff);
  add2Maps ("spp_min_dribble_dist", &spp_min_dribble_dist);
  add2Maps ("spp_max_opp_control_time", &spp_max_opp_control_time);
  add2Maps ("spp_min_pass_conf", &spp_min_pass_conf);
  add2Maps ("spp_min_pass_prob", &spp_min_pass_prob);
  add2Maps ("spp_pass_watch_for_others", &spp_pass_watch_for_others);
  add2Maps ("spp_coach_wait_buffer", &spp_coach_wait_buffer);
  add2Maps ("spp_player_coach_wait_buffer", &spp_player_coach_wait_buffer);
  add2Maps ("spp_coach_default_plan_time", &spp_coach_default_plan_time);
  add2Maps ("spp_players_replace_nums", &spp_players_replace_nums);
  add2Maps ("spp_use_active_cycles", &spp_use_active_cycles);
  add2Maps ("spp_dist_to_end_for_ck", &spp_dist_to_end_for_ck);
  add2Maps ("spp_cycles_to_kick_buffer", &spp_cycles_to_kick_buffer);
  add2Maps ("spp_gk_start_buffer", &spp_gk_start_buffer);
  add2Maps ("spp_send_mode", &spp_send_mode);
  add2Maps ("spp_off_dash_pow", &spp_off_dash_pow);
  add2Maps ("spp_def_dash_pow", &spp_def_dash_pow);

  add2Maps ("spp_forbid_area_buffer", &spp_forbid_area_buffer);
  add2Maps ("spp_sideline_buffer", &spp_sideline_buffer);

  add2Maps ("spp_min_pass_dist", &spp_min_pass_dist);
  add2Maps ("spp_max_pass_dist", &spp_max_pass_dist);
  add2Maps ("spp_max_send_dist", &spp_max_send_dist);

  add2Maps ("spp_frac_to_focus_best", &spp_frac_to_focus_best);
  add2Maps ("spp_hillclimb_num_paths", &spp_hillclimb_num_paths);
  add2Maps ("spp_hillclimb_min_len", &spp_hillclimb_min_len);
  add2Maps ("spp_hillclimb_max_len", &spp_hillclimb_max_len);
  add2Maps ("spp_hillclimb_def_file", &spp_hillclimb_def_file);

  add2Maps ("spp_base_valid_time", &spp_base_valid_time);
  add2Maps ("spp_position_buffer", &spp_position_buffer);

  add2Maps ("spp_pass_target_speed", &spp_pass_target_speed);

  add2Maps ("spp_draw_planned_waypoints", &spp_draw_planned_waypoints);
  add2Maps ("spp_draw_planned_waypoints_scale", &spp_draw_planned_waypoints_scale);
  add2Maps ("spp_draw_planned_waypoints_fstem", &spp_draw_planned_waypoints_fstem);

  add2Maps ("spp_unum_move_for_kickoff", &spp_unum_move_for_kickoff);

  // Opponent Model params
  add2Maps ("spp_om_weight_boost", &spp_om_weight_boost);

  add2Maps ("spp_om_side_to_analyze", &spp_om_side_to_analyze);
  add2Maps ("spp_om_team_to_analyze", &spp_om_team_to_analyze);
  
  add2Maps ("spp_om_opp_model_set_fn", &spp_om_opp_model_set_fn);

  add2Maps ("spp_om_weight_output_fn", &spp_om_weight_output_fn);
  add2Maps ("spp_om_dist_output_fn", &spp_om_dist_output_fn);

  add2Maps ("spp_om_player_delay", &spp_om_player_delay);

  add2Maps ("spp_om_calc_prob_correct_fn", &spp_om_calc_prob_correct_fn);
  add2Maps ("spp_om_prob_correct_samples_max", &spp_om_prob_correct_samples_max);
  add2Maps ("spp_om_prob_correct_samples_step", &spp_om_prob_correct_samples_step);
  add2Maps ("spp_om_prob_correct_num_reps", &spp_om_prob_correct_num_reps);

  add2Maps ("spp_om_obs_interval", &spp_om_obs_interval);
  add2Maps ("spp_om_max_ball_steps", &spp_om_max_ball_steps);
  add2Maps ("spp_om_grid_cell_width", &spp_om_grid_cell_width);
  add2Maps ("spp_om_grid_cell_height", &spp_om_grid_cell_height);
  add2Maps ("spp_om_num_models", &spp_om_num_models);
  add2Maps ("spp_om_max_player_dist", &spp_om_max_player_dist);

  add2Maps ("spp_om_num_exits", &spp_om_num_exits);
  add2Maps ("spp_om_use_weights", &spp_om_use_weights);

  // defensive set players
  add2Maps ("dsp_use_def_set_plays", &dsp_use_def_set_plays);
  add2Maps ("dsp_def_same_pos_buffer", &dsp_def_same_pos_buffer);
  
  add2Maps ("dsp_num_gk_definites", &dsp_num_gk_definites);
  add2Maps ("dsp_num_fk_definites", &dsp_num_fk_definites);
  add2Maps ("dsp_num_ki_definites", &dsp_num_ki_definites);
  add2Maps ("dsp_num_ko_definites", &dsp_num_ko_definites);
  add2Maps ("dsp_num_gc_definites", &dsp_num_gc_definites);
  add2Maps ("dsp_num_ck_definites", &dsp_num_ck_definites);

  add2Maps ("dsp_num_gk_exits", &dsp_num_gk_exits);
  add2Maps ("dsp_num_fk_exits", &dsp_num_fk_exits);
  add2Maps ("dsp_num_ki_exits", &dsp_num_ki_exits);
  add2Maps ("dsp_num_ko_exits", &dsp_num_ko_exits);
  add2Maps ("dsp_num_gc_exits", &dsp_num_gc_exits);
  add2Maps ("dsp_num_ck_exits", &dsp_num_ck_exits);

  add2Maps ("dsp_num_def_ki_extra", &dsp_num_def_ki_extra);

  add2Maps ("use_mod_stat_image", &use_mod_stat_image);
  add2Maps ("mod_stat_draw_world_state", &mod_stat_draw_world_state);
  add2Maps ("mod_stat_world_state_scale", &mod_stat_world_state_scale);
  add2Maps ("mod_stat_world_state_fstem", &mod_stat_world_state_fstem);
  add2Maps ("mod_stat_world_state_interval", &mod_stat_world_state_interval);
  add2Maps ("mod_stat_draw_ball_path", &mod_stat_draw_ball_path);
  add2Maps ("mod_stat_ball_path_scale", &mod_stat_ball_path_scale);
  add2Maps ("mod_stat_ball_path_fstem", &mod_stat_ball_path_fstem);
  add2Maps ("mod_stat_ball_path_refresh_interval", &mod_stat_ball_path_refresh_interval);
  add2Maps ("mod_stat_ball_path_sample_interval", &mod_stat_ball_path_sample_interval);
  add2Maps ("mod_stat_ball_path_use_rec", &mod_stat_ball_path_use_rec);
  add2Maps ("mod_stat_ball_path_rec_corners", &mod_stat_ball_path_rec_corners, 4, 4);
  add2Maps ("mod_stat_ball_path_rec_use_colors", &mod_stat_ball_path_rec_use_colors);
  add2Maps ("mod_stat_ball_path_owner_side", &mod_stat_ball_path_owner_side);
  add2Maps ("mod_stat_do_misc", &mod_stat_do_misc);
  add2Maps ("mod_stat_misc_out_fn", &mod_stat_misc_out_fn);
  add2Maps ("mod_stat_min_control_length", &mod_stat_min_control_length);
  add2Maps ("mod_stat_misc_ball_rec", &mod_stat_misc_ball_rec, 4, 4);
  add2Maps ("mod_stat_misc_ball_in_rec_x_fn", &mod_stat_misc_ball_in_rec_x_fn);

  add2Maps ("use_mod_abstract", &use_mod_abstract);

  add2Maps ("abstract_send_ball_kickable_filter", &abstract_send_ball_kickable_filter);
  add2Maps ("abstract_ball_kickable_filter_buffer", &abstract_ball_kickable_filter_buffer);

  add2Maps ("abstract_track_po", &abstract_track_po);
  add2Maps ("abstract_track_po_set_fn", &abstract_track_po_set_fn);
  add2Maps ("abstract_track_po_write_per_cycle", &abstract_track_po_write_per_cycle);
  add2Maps ("abstract_track_po_per_cycle_fn", &abstract_track_po_per_cycle_fn);
  add2Maps ("abstract_track_po_write_summ", &abstract_track_po_write_summ);
  add2Maps ("abstract_track_po_summ_fn", &abstract_track_po_summ_fn);
  add2Maps ("abstract_track_po_only_play_on", &abstract_track_po_only_play_on);
  add2Maps ("abstract_track_po_only_kickable", &abstract_track_po_only_kickable);
  add2Maps ("abstract_track_po_both_teams", &abstract_track_po_both_teams);

  add2Maps ("abstract_draw_poset", &abstract_draw_poset);
  add2Maps ("abstract_draw_poset_in_fn", &abstract_draw_poset_in_fn);
  add2Maps ("abstract_draw_poset_state_num", &abstract_draw_poset_state_num);

  add2Maps ("abstract_state_track", &abstract_state_track);
  add2Maps ("abstract_state_poset_fn", &abstract_state_poset_fn);
  add2Maps ("abstract_state_ball_num_x_bins", &abstract_state_ball_num_x_bins);
  add2Maps ("abstract_state_ball_num_y_bins", &abstract_state_ball_num_y_bins);
  add2Maps ("abstract_state_track_write_summ", &abstract_state_track_write_summ);
  add2Maps ("abstract_state_track_summ_fn", &abstract_state_track_summ_fn);
  add2Maps ("abstract_state_track_write_per_cycle", &abstract_state_track_write_per_cycle);
  add2Maps ("abstract_state_track_per_cycle_fn", &abstract_state_track_per_cycle_fn);
  add2Maps ("abstract_state_track_both_teams", &abstract_state_track_both_teams);

  add2Maps ("abstract_learn_markov_chain", &abstract_learn_markov_chain);
  add2Maps ("abstract_learn_markov_chain_in_fn", &abstract_learn_markov_chain_in_fn);
  add2Maps ("abstract_learn_markov_chain_out_fn", &abstract_learn_markov_chain_out_fn);
  add2Maps ("abstract_learn_markov_chain_new_states_fn", &abstract_learn_markov_chain_new_states_fn);
  add2Maps ("abstract_learn_markov_chain_new_tran_fn", &abstract_learn_markov_chain_new_tran_fn);
  add2Maps ("abstract_learn_markov_chain_states", &abstract_learn_markov_chain_states);
  
  add2Maps ("abstract_learn_mcv", &abstract_learn_mcv);
  add2Maps ("abstract_learn_mcv_chain_fn", &abstract_learn_mcv_chain_fn);
  add2Maps ("abstract_learn_mcv_in_value_fn", &abstract_learn_mcv_in_value_fn);
  add2Maps ("abstract_learn_mcv_out_value_fn", &abstract_learn_mcv_out_value_fn);
  add2Maps ("abstract_learn_mcv_progress_interval", &abstract_learn_mcv_progress_interval);
  add2Maps ("abstract_learn_mcv_total_change_lim", &abstract_learn_mcv_total_change_lim);
  add2Maps ("abstract_learn_mcv_per_cap_change_lim", &abstract_learn_mcv_per_cap_change_lim);
  add2Maps ("abstract_learn_mcv_iter_lim", &abstract_learn_mcv_iter_lim);
  add2Maps ("abstract_learn_mcv_discount_factor", &abstract_learn_mcv_discount_factor);

  add2Maps ("abstract_prune_mc", &abstract_prune_mc);
  add2Maps ("abstract_prune_mc_in_fn", &abstract_prune_mc_in_fn);
  add2Maps ("abstract_prune_mc_out_fn", &abstract_prune_mc_out_fn);
  add2Maps ("abstract_prune_mc_nuke_self_min", &abstract_prune_mc_nuke_self_min);
  add2Maps ("abstract_prune_mc_nuke_self_max", &abstract_prune_mc_nuke_self_max);
  add2Maps ("abstract_prune_mc_target_state", &abstract_prune_mc_target_state);
  add2Maps ("abstract_prune_mc_tran_fn", &abstract_prune_mc_tran_fn);

  add2Maps ("abstract_mc_create_graph", &abstract_mc_create_graph);
  add2Maps ("abstract_mc_graph_chain_fn", &abstract_mc_graph_chain_fn);
  add2Maps ("abstract_mc_graph_value_fn", &abstract_mc_graph_value_fn);
  add2Maps ("abstract_mc_graph_tree_value_fn", &abstract_mc_graph_tree_value_fn);
  add2Maps ("abstract_mc_graph_out_graph_fn", &abstract_mc_graph_out_graph_fn);
  add2Maps ("abstract_mc_graph_name", &abstract_mc_graph_name);
  add2Maps ("abstract_mc_graph_root_state", &abstract_mc_graph_root_state);

  add2Maps ("abstract_mc_calc_dist", &abstract_mc_calc_dist);
  add2Maps ("abstract_mc_calc_dist_target_state", &abstract_mc_calc_dist_target_state);
  add2Maps ("abstract_mc_calc_dist_chain_fn", &abstract_mc_calc_dist_chain_fn);
  add2Maps ("abstract_mc_calc_dist_value_fn", &abstract_mc_calc_dist_value_fn);

  add2Maps ("abstract_draw_states", &abstract_draw_states);
  add2Maps ("abstract_draw_state_num", &abstract_draw_state_num);
  add2Maps ("abstract_draw_state_cycle_fn", &abstract_draw_state_cycle_fn);
  add2Maps ("abstract_draw_state_out_fpat", &abstract_draw_state_out_fpat);
  add2Maps ("abstract_draw_scale", &abstract_draw_scale);
  add2Maps ("abstract_draw_legend_lines", &abstract_draw_legend_lines);

  add2Maps ("abstract_classify_mc", &abstract_classify_mc);
  add2Maps ("abstract_classify_mc_in_mc_fn", &abstract_classify_mc_in_mc_fn);
  add2Maps ("abstract_classify_mc_in_asdcset_fn", &abstract_classify_mc_in_asdcset_fn);
  add2Maps ("abstract_classify_mc_out_full_fn", &abstract_classify_mc_out_full_fn);
  add2Maps ("abstract_classify_mc_out_summ_fn", &abstract_classify_mc_out_summ_fn);

  add2Maps ("abstract_convert_mdp", &abstract_convert_mdp);
  add2Maps ("abstract_convert_mdp_in_mc_fn", &abstract_convert_mdp_in_mc_fn);
  add2Maps ("abstract_convert_mdp_in_asdcset_fn", &abstract_convert_mdp_in_asdcset_fn);
  add2Maps ("abstract_convert_mdp_in_tsort_fn", &abstract_convert_mdp_in_tsort_fn);
  add2Maps ("abstract_convert_mdp_out_mdp_fn", &abstract_convert_mdp_out_mdp_fn);

  add2Maps ("abstract_solve_mdp", &abstract_solve_mdp);
  add2Maps ("abstract_solve_mdp_in_mdp_fn", &abstract_solve_mdp_in_mdp_fn);
  add2Maps ("abstract_solve_mdp_out_qt_fn", &abstract_solve_mdp_out_qt_fn);
  add2Maps ("abstract_solve_mdp_gamma", &abstract_solve_mdp_gamma);

  add2Maps ("abstract_show_mdp_state", &abstract_show_mdp_state);
  add2Maps ("abstract_show_mdp_state_mdp_fn", &abstract_show_mdp_state_mdp_fn);
  add2Maps ("abstract_show_mdp_state_num", &abstract_show_mdp_state_num);

  add2Maps ("abstract_advice_by_mdp", &abstract_advice_by_mdp);
  add2Maps ("abstract_abmdp_fn", &abstract_abmdp_fn);
  add2Maps ("abstract_abmdp_qtable_fn", &abstract_abmdp_qtable_fn);
  add2Maps ("abstract_abmdp_perc_opt", &abstract_abmdp_perc_opt);
  add2Maps ("abstract_abmdp_choose_worst_actions", &abstract_abmdp_choose_worst_actions);
  add2Maps ("abstract_abmdp_send_advice", &abstract_abmdp_send_advice);
  add2Maps ("abstract_abmdp_rank_filter_fn", &abstract_abmdp_rank_filter_fn);
  add2Maps ("abstract_abmdp_rank_filter_count", &abstract_abmdp_rank_filter_count);
  add2Maps ("abstract_abmdp_rank_filter_from_top", &abstract_abmdp_rank_filter_from_top);
  add2Maps ("abstract_abmdp_value_filter_fn", &abstract_abmdp_value_filter_fn);
  add2Maps ("abstract_abmdp_value_filter_min", &abstract_abmdp_value_filter_min);
  add2Maps ("abstract_abmdp_value_filter_max", &abstract_abmdp_value_filter_max);
  add2Maps ("abstract_abmdp_use_advice_tree", &abstract_abmdp_use_advice_tree);
  add2Maps ("abstract_abmdp_advice_tree_shuffle", &abstract_abmdp_advice_tree_shuffle);
  add2Maps ("abstract_abmdp_create_tree_assoc", &abstract_abmdp_create_tree_assoc);
  add2Maps ("abstract_abmdp_tree_assoc_fn", &abstract_abmdp_tree_assoc_fn);
  add2Maps ("abstract_abmdp_track", &abstract_abmdp_track);
  add2Maps ("abstract_abmdp_track_fn", &abstract_abmdp_track_fn);
  add2Maps ("abstract_abmdp_use_back_channel", &abstract_abmdp_use_back_channel);
  add2Maps ("abstract_abmdp_back_channel_fn", &abstract_abmdp_back_channel_fn);

  add2Maps ("abstract_abmdp_multi_count", &abstract_abmdp_multi_count);
  add2Maps ("abstract_abmdp_multi_poset_fn", &abstract_abmdp_multi_poset_fn, 0, -1);
  add2Maps ("abstract_abmdp_multi_mdp_fn", &abstract_abmdp_multi_mdp_fn, 0, -1);
  add2Maps ("abstract_abmdp_multi_qtable_fn", &abstract_abmdp_multi_qtable_fn, 0, -1);
  add2Maps ("abstract_abmdp_multi_tree_assoc_fpat", &abstract_abmdp_multi_tree_assoc_fpat);
  add2Maps ("abstract_abmdp_multi_strat_to_mdp_idx", &abstract_abmdp_multi_strat_to_mdp_idx, 0, -1);
  
  add2Maps ("abstract_mdp_pass_expand_y_int", &abstract_mdp_pass_expand_y_int);
  add2Maps ("abstract_mdp_pass_expand_slope", &abstract_mdp_pass_expand_slope);
  add2Maps ("abstract_mdp_generate_pass_pos_advice", &abstract_mdp_generate_pass_pos_advice);

  add2Maps ("abstract_analyze_qtable", &abstract_analyze_qtable);
  add2Maps ("abstract_analyze_qtable_fn", &abstract_analyze_qtable_fn );
  add2Maps ("abstract_analyze_qtable_out_sv_max_fn", &abstract_analyze_qtable_out_sv_max_fn);
  add2Maps ("abstract_analyze_qtable_out_sv_range_fn", &abstract_analyze_qtable_out_sv_range_fn);

  add2Maps ("abstract_compare_state_trace_to_model", &abstract_compare_state_trace_to_model);
  add2Maps ("abstract_compare_st2m_in_list_fn", &abstract_compare_st2m_in_list_fn);
  add2Maps ("abstract_compare_st2m_ignore_self_tran_min", &abstract_compare_st2m_ignore_self_tran_min);
  add2Maps ("abstract_compare_st2m_ignore_self_tran_max", &abstract_compare_st2m_ignore_self_tran_max);

  add2Maps ("abstract_compute_avg_reward", &abstract_compute_avg_reward);
  add2Maps ("abstract_compute_ar_start_state", &abstract_compute_ar_start_state);
  add2Maps ("abstract_compute_ar_num_steps", &abstract_compute_ar_num_steps);
  add2Maps ("abstract_compute_ar_num_reps", &abstract_compute_ar_num_reps);

  add2Maps ("abstract_analyze_mdp", &abstract_analyze_mdp);
  add2Maps ("abstract_analyze_mdp_in_fn", &abstract_analyze_mdp_in_fn);

  add2Maps ("abstract_generate_mdp_traces", &abstract_generate_mdp_traces);
  add2Maps ("abstract_generate_mdp_traces_count", &abstract_generate_mdp_traces_count);
  add2Maps ("abstract_generate_mdp_traces_steps", &abstract_generate_mdp_traces_steps);
  add2Maps ("abstract_generate_mdp_traces_out_fn", &abstract_generate_mdp_traces_out_fn);
  add2Maps ("abstract_generate_mdp_traces_use_max", &abstract_generate_mdp_traces_use_max);
  
  add2Maps ("abstract_convert_to_binary", &abstract_convert_to_binary);
  add2Maps ("abstract_convert_qtable_in_fn", &abstract_convert_qtable_in_fn);
  add2Maps ("abstract_convert_qtable_out_fn", &abstract_convert_qtable_out_fn);
  add2Maps ("abstract_convert_mdp_in_fn", &abstract_convert_mdp_in_fn);
  add2Maps ("abstract_convert_mdp_out_fn", &abstract_convert_mdp_out_fn);
  
  add2Maps ("abstract_analyze_percent_optimal", &abstract_analyze_percent_optimal);
  add2Maps ("abstract_analyze_percent_optimal_values", &abstract_analyze_percent_optimal_values, 0, -1);
  add2Maps ("abstract_analyze_percent_optimal_out_dir", &abstract_analyze_percent_optimal_out_dir);

  add2Maps ("use_mod_features", &use_mod_features);
  add2Maps ("features_cycles_to_store", &features_cycles_to_store);
  add2Maps ("features_create_ball_owner_log", &features_create_ball_owner_log);
  add2Maps ("features_ball_owner_log_fn", &features_ball_owner_log_fn);
  add2Maps ("features_create_ball_possess_log", &features_create_ball_possess_log);
  add2Maps ("features_ball_possess_log_fn", &features_ball_possess_log_fn);

  add2Maps ("use_mod_trainer", &use_mod_trainer);
  add2Maps ("trainer_drop_ball_interval", &trainer_drop_ball_interval);
  add2Maps ("trainer_drop_ball_spots_fn", &trainer_drop_ball_spots_fn);

  add2Maps ("use_mod_global_adapt", &use_mod_global_adapt);
  add2Maps ("global_adapt_read_results", &global_adapt_read_results);
  add2Maps ("global_adapt_in_results_fn", &global_adapt_in_results_fn);
  add2Maps ("global_adapt_write_results", &global_adapt_write_results);
  add2Maps ("global_adapt_out_results_fn", &global_adapt_out_results_fn);
  add2Maps ("global_adapt_append", &global_adapt_append);
  add2Maps ("global_adapt_initial_strategy_style", &global_adapt_initial_strategy_style);
  add2Maps ("global_adapt_initial_strategy_index", &global_adapt_initial_strategy_index);
  add2Maps ("global_adapt_adjust_interval", &global_adapt_adjust_interval);
  add2Maps ("global_adapt_adjust_after_goals", &global_adapt_adjust_after_goals);
  add2Maps ("global_adapt_adjust_at_stoppage", &global_adapt_adjust_at_stoppage);
  add2Maps ("global_adapt_use_fixed_advice", &global_adapt_use_fixed_advice);
  add2Maps ("global_adapt_fixed_advice_map_fn", &global_adapt_fixed_advice_map_fn);
  add2Maps ("global_adapt_good_data_amt_threshold", &global_adapt_good_data_amt_threshold);

}

void
CoachParam::setDefaultValues ()
{
  PlayerParam::setDefaultValues();

  logfile_dir = "Logfiles";
  action_log_fn = "actions.log";
  action_log_level = 0;

  send_log_fn = "send.log";
  recv_log_fn = "recv.log";

  trainer_send_log_fn = "trainer_send.log";
  trainer_recv_log_fn = "trainer_recv.log";

  run_mode_str = "null";
  run_mode = RM_Invalid;
    
  online_host = "localhost";
  online_port = 6002;
  online_trainer_port = 6001;
  online_max_time_wout_msg = 5;
  
  team_name = "NO TEAM";
  coach_name = "CMOwl";
  server_protocol_version = 9.0;

  create_command_log = true;
  command_log_fn = "commands.log";

  logfile_fn = "";
  logfile_side_to_analyze = "None";
  logfile_team_to_analyze = "";
  
  cycles_to_store = 5;

  use_mod_test = false;

  use_mod_cmrep = false;
  initial_messages_fn = "";
  init_messages_delay = 5;
  min_players_before_say = 11;
  max_say_length = 999999;
  max_says_per_cycle = 1;
  say_frequency = 1;

  use_mod_formation = false;
  formation_point_weight = 0.95;
  formation_re_max_steps = 8000;
  formation_re_stdev = 10;
  formation_hc_max_steps = 30000;
  formation_hc_lrate = .1;
  formation_use_random = false;
  formation_learn = false;
  formation_side_to_learn = "none";
  formation_team_to_learn = "none";
  formation_learn_sample_step = 5;
  formation_learn_output_fn = "learn.form";
  formation_combine_data = false;
  formation_learn_data_fn = "form-gather.data";
  formation_opp_form_fn = "";
  formation_gather_data = false;
  formation_send_form = true;
  formation_send_marks = false;
  formation_list_fn = "Formations/formation.list";
  formation_num_per_adapt_style.push_back(2);
  formation_num_per_adapt_style.push_back(2);
  formation_num_per_adapt_style.push_back(2);
  formation_formatters.push_back("null");
  formation_formatters.push_back("home");
  formation_formatters.push_back("home");
  formation_formatters.push_back("home");
  formation_formatters.push_back("home");
  formation_formatters.push_back("home");
  formation_formatters.push_back("home");
  formation_formatters.push_back("home");
  formation_formatters.push_back("home");
  formation_formatters.push_back("home");
  formation_formatters.push_back("home");
  formation_draw = false;
  formation_draw_output_dir = "Formations";

  team_min_kick_speed = 1.56;
  team_avg_kick_speed = 2.2;
  team_max_kick_speed = 2.52;
  team_min_time_turn_when_going = 1;
  team_min_cycles_to_kick = 1;
  team_avg_cycles_to_kick = 8;
  team_max_cycles_to_kick = 12;

  use_mod_setplay_plan = false;

  spp_planner_type = 0;
  spp_offside_worry_dist = 5;  
  spp_offset_perc_speed = .5;
  spp_offset_delay = 4;
  spp_reuse_agents = true;
  
  spp_hillclimb_max_stat_steps = 40;
  spp_hillclimb_max_steps = -1;
  spp_hillclimb_resample_freq = 40;
  spp_hillclimb = true;
  spp_hillclimb_always_first = false;
    
  spp_pot_cell_length = 2.0;
  spp_pot_cell_width = 2.0;
  spp_pot_max_levels = 5;
  spp_pot_max_neigh = 5;
  spp_pot_pass_incr = 4.0;

  spp_eval_loc_weight = 20;
  spp_eval_bad_wp_weight = -10;
  spp_eval_length_weight = 10;
  spp_eval_pass_weight = 10;
  spp_eval_avg_occ_weight = 20;
  spp_eval_max_occ_weight = 20;
  spp_eval_sample_density = 1.0;
  spp_eval_sample_extra_len = 2.0;
  spp_eval_sample_wd_ratio = .3;
  spp_eval_send_base_max = 1.0;
  spp_eval_send_pen_max = 0.7;
  spp_eval_offplay_perc_speed = .8;
  spp_eval_offplay_delay = 3;
  spp_eval_opp_delay = 2;
  spp_eval_opp_speed = .9;

  spp_plans_dir = "../shared/Plans";
  spp_def_my_kick_off1 = "my_kick_off1";
  spp_def_my_kick_off2 = "my_kick_off2";
  spp_def_my_kick_in1 = "my_kick_in1";
  spp_def_my_kick_in2 = "my_kick_in2";
  spp_def_my_corner_kick1 = "my_corner_kick1";
  spp_def_my_corner_kick2 = "my_corner_kick2";
  spp_def_my_goal_kick1 = "my_goal_kick1";
  spp_def_my_goal_kick2 = "my_goal_kick2";
  spp_def_my_free_kick1 = "my_free_kick1";
  spp_def_my_free_kick2 = "my_free_kick2";
  spp_def_my_goalie_catch1 = "my_goalie_catch1";
  spp_def_my_goalie_catch2 = "my_goalie_catch2";

  spp_def_their_kick_off = "their_kick_off";
  spp_def_their_kick_in = "their_kick_in";
  spp_def_their_corner_kick = "their_corner_kick";
  spp_def_their_goal_kick = "their_goal_kick";
  spp_def_their_free_kick = "their_free_kick";
  spp_def_their_goalie_catch = "their_goalie_catch";

  spp_min_obs_time = 5;
  spp_obs_on_lost_ball = true;

  spp_draw_waypoints = false;

  spp_max_coach_wait    = 50;  
  spp_delay             = 5;
  spp_max_delay         = 100;
  spp_max_player_setup  = 175;
  spp_max_player_setup_for_gc  = 175;
  spp_time_limit        = 150;
  spp_kickoff_fixed_pos_time = 3;
//spp_init_dash_pow     = 35; //stamina_inc_max
  spp_at_point_buffer = 2;
  spp_kick_dir_ang_buffer = 90;
  spp_kick_complete_dist = 2;
  spp_min_goto_dist = 3 ;
  spp_kickable_buffer = 1.5; //same as breakaway
  spp_use_bpi_cyc_diff = 10;
  spp_min_dribble_dist = 3;
  spp_max_opp_control_time = 2;
  spp_min_pass_conf = .5;
  spp_min_pass_prob = .4;
  spp_pass_watch_for_others = true;
  spp_coach_wait_buffer = 5;
  spp_player_coach_wait_buffer = 15;
  spp_coach_default_plan_time = 2;
  spp_players_replace_nums = true;
  spp_use_active_cycles = 4;
  spp_dist_to_end_for_ck = 45;
  spp_cycles_to_kick_buffer = 3;
  spp_gk_start_buffer = 5.0;
  spp_send_mode = 0;
  spp_off_dash_pow = 35;
  spp_def_dash_pow = 35;

  spp_forbid_area_buffer = 1.0;
  spp_sideline_buffer = 2;

  spp_min_pass_dist = 7;
  spp_max_pass_dist = 20; 
  spp_max_send_dist = 50;

  spp_frac_to_focus_best = 2.0/3.0;
  spp_hillclimb_num_paths = 20;
  spp_hillclimb_min_len = 3;
  spp_hillclimb_max_len = 6;
  spp_hillclimb_def_file = "../shared/Plans/def_waypoints";

  spp_base_valid_time = 200;
  spp_position_buffer = 4.0; 

  spp_pass_target_speed = 2.0;

  spp_draw_planned_waypoints = false;
  spp_draw_planned_waypoints_scale = 4;
  spp_draw_planned_waypoints_fstem = "Images/planned_setplay_";

  spp_unum_move_for_kickoff = -1;

  spp_om_weight_boost = .1; 

  spp_om_side_to_analyze = "NoValue";
  spp_om_team_to_analyze = "";

  spp_om_opp_model_set_fn = "OppModel.conf";

  spp_om_weight_output_fn = "";
  spp_om_dist_output_fn = "";

  spp_om_player_delay = 2;

  spp_om_calc_prob_correct_fn = "";
  spp_om_prob_correct_samples_max = 50;
  spp_om_prob_correct_samples_step = 1;
  spp_om_prob_correct_num_reps = 500;

  spp_om_obs_interval = 5;
  spp_om_max_ball_steps = 20;
  spp_om_grid_cell_width = 1.0;
  spp_om_grid_cell_height = 1.0;
  spp_om_num_models = 1;
  spp_om_max_player_dist = 60;
  spp_om_num_exits = 5;
  spp_om_use_weights = true;

  // defensive set play param
  dsp_use_def_set_plays = true;
  dsp_def_same_pos_buffer = 3.0;

  dsp_num_gk_definites = 1;
  dsp_num_fk_definites = 1;
  dsp_num_ki_definites = 1;
  dsp_num_ko_definites = 1;
  dsp_num_gc_definites = 0;
  dsp_num_ck_definites = 4;

  dsp_num_gk_exits = 2;
  dsp_num_fk_exits = 2;
  dsp_num_ki_exits = 2;
  dsp_num_ko_exits = 2;
  dsp_num_gc_exits = 4;
  dsp_num_ck_exits = 1;

  dsp_num_def_ki_extra = 2;

  use_mod_stat_image = false;
  mod_stat_draw_world_state = false;
  mod_stat_world_state_scale = 4;
  mod_stat_world_state_fstem = "Images/world_state_";
  mod_stat_world_state_interval = 5;
  mod_stat_draw_ball_path = false;
  mod_stat_ball_path_scale = 6;
  mod_stat_ball_path_fstem = "Images/ball_path_";
  mod_stat_ball_path_refresh_interval = 600;
  mod_stat_ball_path_sample_interval = 2;
  mod_stat_ball_path_use_rec = false;
  mod_stat_ball_path_rec_corners.push_back(-52.5);
  mod_stat_ball_path_rec_corners.push_back(-32);
  mod_stat_ball_path_rec_corners.push_back(52.5);
  mod_stat_ball_path_rec_corners.push_back(32);
  mod_stat_ball_path_rec_use_colors = true;
  mod_stat_ball_path_owner_side = "both";
  mod_stat_do_misc = false;
  mod_stat_misc_out_fn = "stats.log";
  mod_stat_min_control_length = 7;
  mod_stat_misc_ball_rec.push_back(-52.5);
  mod_stat_misc_ball_rec.push_back(-32);
  mod_stat_misc_ball_rec.push_back(52.5);
  mod_stat_misc_ball_rec.push_back(32);
  mod_stat_misc_ball_in_rec_x_fn.clear();

  use_mod_abstract = false;

  abstract_send_ball_kickable_filter = false;
  abstract_ball_kickable_filter_buffer = 0.5;

  abstract_track_po = false;
  abstract_track_po_set_fn = "testin.poset";
  abstract_track_po_write_per_cycle = true;
  abstract_track_po_per_cycle_fn = "potrack_cycle.log";
  abstract_track_po_write_summ = true;
  abstract_track_po_summ_fn = "potrack_summ.log";
  abstract_track_po_only_play_on = true;
  abstract_track_po_only_kickable = true;
  abstract_track_po_both_teams = false;

  abstract_draw_poset = false;
  abstract_draw_poset_in_fn = "";
  abstract_draw_poset_state_num = -1;
  
  abstract_state_track = false;
  abstract_state_poset_fn = "testin.poset";
  abstract_state_ball_num_x_bins = 10;
  abstract_state_ball_num_y_bins = 6;
  abstract_state_track_write_summ = true;
  abstract_state_track_summ_fn = "absstate_summ.log";
  abstract_state_track_write_per_cycle = true;
  abstract_state_track_per_cycle_fn = "absstate_cycle.log";
  abstract_state_track_both_teams = false;
  
  abstract_learn_markov_chain = false;
  abstract_learn_markov_chain_in_fn = "";
  abstract_learn_markov_chain_out_fn = "learned.mc";
  abstract_learn_markov_chain_new_states_fn = "mc_learn_new_states.log";
  abstract_learn_markov_chain_new_tran_fn = "mc_learn_new_tran.log";
  abstract_learn_markov_chain_states = 0;
  
  abstract_learn_mcv = false;
  abstract_learn_mcv_chain_fn = "";
  abstract_learn_mcv_in_value_fn = "";
  abstract_learn_mcv_out_value_fn = "learned.mcv";
  abstract_learn_mcv_progress_interval = 10000;
  abstract_learn_mcv_total_change_lim = -1;
  abstract_learn_mcv_per_cap_change_lim = -1;
  abstract_learn_mcv_iter_lim = 1000;
  abstract_learn_mcv_discount_factor = .99;

  abstract_prune_mc = false;
  abstract_prune_mc_in_fn = "";
  abstract_prune_mc_out_fn = "pruned.mc";
  abstract_prune_mc_nuke_self_min = -1;
  abstract_prune_mc_nuke_self_max = -1;
  abstract_prune_mc_target_state = -1;  
  abstract_prune_mc_tran_fn = "";

  abstract_mc_create_graph = false;
  abstract_mc_graph_chain_fn = "";
  abstract_mc_graph_value_fn = "";
  abstract_mc_graph_tree_value_fn = "";
  abstract_mc_graph_out_graph_fn = "markov_chain.graph";
  abstract_mc_graph_name = "MarkovChainGraph";
  abstract_mc_graph_root_state = 0;

  abstract_mc_calc_dist = false;
  abstract_mc_calc_dist_target_state = -1;
  abstract_mc_calc_dist_chain_fn = "";
  abstract_mc_calc_dist_value_fn = "dist.mcv";

  abstract_draw_states = false;
  abstract_draw_state_num = -1;
  abstract_draw_state_cycle_fn = "";
  abstract_draw_state_out_fpat = "absstate_%S";
  abstract_draw_scale = 6;
  abstract_draw_legend_lines = 5;

  abstract_classify_mc = false;
  abstract_classify_mc_in_mc_fn = "";
  abstract_classify_mc_in_asdcset_fn = "";
  abstract_classify_mc_out_full_fn = "classify-full.out";
  abstract_classify_mc_out_summ_fn = "classify-summ.out";

  abstract_convert_mdp = false;
  abstract_convert_mdp_in_mc_fn = "";
  abstract_convert_mdp_in_asdcset_fn = "";
  abstract_convert_mdp_in_tsort_fn = "";
  abstract_convert_mdp_out_mdp_fn = "mc_convert.mdp";

  abstract_solve_mdp = false;
  abstract_solve_mdp_in_mdp_fn = "";
  abstract_solve_mdp_out_qt_fn = "";
  abstract_solve_mdp_gamma = 0.99;

  abstract_show_mdp_state = false;
  abstract_show_mdp_state_mdp_fn = "";
  abstract_show_mdp_state_num = 0;

  abstract_advice_by_mdp = false;
  abstract_abmdp_fn = "";
  abstract_abmdp_qtable_fn = "";
  abstract_abmdp_perc_opt = .96;
  abstract_abmdp_choose_worst_actions = false;
  abstract_abmdp_send_advice = true;
  abstract_abmdp_rank_filter_fn = "";
  abstract_abmdp_rank_filter_count = -1;
  abstract_abmdp_rank_filter_from_top = true;
  abstract_abmdp_value_filter_fn = "";
  abstract_abmdp_value_filter_min = 1e8;
  abstract_abmdp_value_filter_max = -1e8;
  abstract_abmdp_use_advice_tree = true;
  abstract_abmdp_advice_tree_shuffle = false;
  abstract_abmdp_create_tree_assoc = false;
  abstract_abmdp_tree_assoc_fn = "tree2state.log";
  abstract_abmdp_track = true;
  abstract_abmdp_track_fn = "abmdp_track.log";
  abstract_abmdp_use_back_channel = false;
  abstract_abmdp_back_channel_fn = "/tmp/abmdp_back_channel";

  abstract_abmdp_multi_count = 0;
  abstract_abmdp_multi_poset_fn.clear();
  abstract_abmdp_multi_mdp_fn.clear();
  abstract_abmdp_multi_qtable_fn.clear();
  abstract_abmdp_multi_tree_assoc_fpat = "";
  abstract_abmdp_multi_strat_to_mdp_idx.clear();
  
  abstract_mdp_pass_expand_y_int = -12;
  abstract_mdp_pass_expand_slope = 1;
  abstract_mdp_generate_pass_pos_advice = true;

  abstract_analyze_qtable = false;
  abstract_analyze_qtable_fn = "";  
  abstract_analyze_qtable_out_sv_max_fn = "";
  abstract_analyze_qtable_out_sv_range_fn = "";

  abstract_compare_state_trace_to_model = false;
  abstract_compare_st2m_in_list_fn = "";
  abstract_compare_st2m_ignore_self_tran_min = -1;
  abstract_compare_st2m_ignore_self_tran_max = -1;

  abstract_compute_avg_reward = false;
  abstract_compute_ar_start_state = 0;
  abstract_compute_ar_num_steps = 100;
  abstract_compute_ar_num_reps = 1000;

  abstract_analyze_mdp = false;
  abstract_analyze_mdp_in_fn = "";

  abstract_generate_mdp_traces = false;
  abstract_generate_mdp_traces_count = 1;
  abstract_generate_mdp_traces_steps = 100;
  abstract_generate_mdp_traces_out_fn = "mdp_trace_%I.log";
  abstract_generate_mdp_traces_use_max = false;
  
  abstract_convert_to_binary = false;
  abstract_convert_qtable_in_fn = "";
  abstract_convert_qtable_out_fn = "";
  abstract_convert_mdp_in_fn = "";
  abstract_convert_mdp_out_fn = "";
  
  abstract_analyze_percent_optimal = false;
  abstract_analyze_percent_optimal_values.clear();
  abstract_analyze_percent_optimal_out_dir = "/tmp";
  
  use_mod_features = false;
  features_cycles_to_store = 50;
  features_create_ball_owner_log = false;
  features_ball_owner_log_fn = "ball_owner.log";
  features_create_ball_possess_log = false;
  features_ball_possess_log_fn = "ball_possess.log";

  use_mod_trainer = false;
  trainer_drop_ball_interval = 20;
  trainer_drop_ball_spots_fn = "";

  use_mod_global_adapt = false;
  global_adapt_read_results = false;
  global_adapt_in_results_fn = "ga_results.log";
  global_adapt_write_results = true;
  global_adapt_out_results_fn = "ga_results.log";
  global_adapt_append = true;
  global_adapt_initial_strategy_style = "defensive";
  global_adapt_initial_strategy_index = 0;
  global_adapt_adjust_interval = 1200;
  global_adapt_adjust_after_goals = false;
  global_adapt_adjust_at_stoppage = false;
  global_adapt_use_fixed_advice = false;
  global_adapt_fixed_advice_map_fn = "fixed_advice.map";
  global_adapt_good_data_amt_threshold = 2000;
}

void
CoachParam::postReadProcessing()
{
  PlayerParam::postReadProcessing();

  if (run_mode_str == "null")
    run_mode = RM_Null;
  else if (run_mode_str == "single")
    run_mode = RM_Single;
  else if (run_mode_str == "online")
    run_mode = RM_Online;
  else if (run_mode_str == "logfile")
    run_mode = RM_Logfile;
  else
    errorlog << "Did not understand run_mode '" << run_mode_str << "'" << ende;
}


