/* -*- Mode: C++ -*- */

/* These classes are for all the commands that the coach can send */

#ifndef _COACH_COMMANDS_H_
#define _COACH_COMMANDS_H_

#include <iostream>
#include "clangmsg.h"

/**************************************************************************/

class CoachCommand
{
public:
  CoachCommand() {}
  virtual ~CoachCommand() {}

  friend std::ostream & operator << (std::ostream & o, const CoachCommand& c)
  { c.print(o); return o; }

  virtual void print(std::ostream& o) const = 0;
  
private:
};

/**************************************************************************/

class CoachCommandInit
  : public CoachCommand
{
public:
  CoachCommandInit(std::string team_name, std::string coach_name, double version)
    : CoachCommand(), team_name(team_name), coach_name(coach_name), version(version) {}
  ~CoachCommandInit() {}

  void print(std::ostream& o) const
  { o << "(init " << team_name << " " << coach_name << " (version " << version << "))"; }

private:
  std::string team_name;
  std::string coach_name;
  double version;
};

/**************************************************************************/

class CoachCommandCheckBall
  : public CoachCommand
{
public:
  CoachCommandCheckBall() : CoachCommand() {}
  ~CoachCommandCheckBall() {}

  void print(std::ostream& o) const { o << "(check_ball)"; }
};

/**************************************************************************/

class CoachCommandLook
  : public CoachCommand
{
public:
  CoachCommandLook() : CoachCommand() {}
  ~CoachCommandLook() {}

  void print(std::ostream& o) const { o << "(look)"; }
};

/**************************************************************************/

class CoachCommandTeamNames
  : public CoachCommand
{
public:
  CoachCommandTeamNames() : CoachCommand() {}
  ~CoachCommandTeamNames() {}

  void print(std::ostream& o) const { o << "(team_names)"; }
};

/**************************************************************************/
class CoachCommandSay
  : public CoachCommand
{
public:
  // takes over the memory
  CoachCommandSay(rcss::clang::Msg* msg)
    : CoachCommand(), msg(msg) {}
  ~CoachCommandSay() { if (msg) delete msg; }

  void print(std::ostream& o) const
  { o << "(say " << *msg << ")"; }

private:
  rcss::clang::Msg *msg;
};
/**************************************************************************/

class CoachCommandBye
  : public CoachCommand
{
public:
  CoachCommandBye() : CoachCommand() {}
  ~CoachCommandBye() {}

  void print(std::ostream& o) const { o << "(bye)"; }
};

/**************************************************************************/

class CoachCommandEye
  : public CoachCommand
{
public:
  CoachCommandEye(bool parity)
    : CoachCommand(), parity(parity) {}
  ~CoachCommandEye() {}

  void print(std::ostream& o) const
  { o << "(eye " << (parity ? "on" : "off") << ")"; }

private:
  bool parity;
};

/**************************************************************************/

class CoachCommandChangePlayerType
  : public CoachCommand
{
public:
  CoachCommandChangePlayerType(int num, int type)
    : CoachCommand(), num(num), type(type) {}
  ~CoachCommandChangePlayerType() {}

  void print(std::ostream& o) const
  { o << "(change_player_type " << num << " " << type << ")"; }

private:
  int num;
  int type;
};

/**************************************************************************/

class CoachCommandDone
  : public CoachCommand
{
public:
  CoachCommandDone() : CoachCommand() {}
  ~CoachCommandDone() {}

  void print(std::ostream& o) const { o << "(done)"; }
};

/**************************************************************************/

class CoachCommandCompression
  : public CoachCommand
{
public:
  CoachCommandCompression(int level)
    : CoachCommand(), level(level) {}
  ~CoachCommandCompression() {}

  void print(std::ostream& o) const
  { o << "(compression " << level << ")"; }

private:
  int level;
};

/**************************************************************************/

//SMURF: team graphic is not implemented



#endif
