
#include "CLangFileReader.h"
#include "clangparser.h"
#include "clangmsgbuilder.h"
#include "clangmsg.h"
#include "SorterMsgBuilder.h"
#include "CLangFileReader.h"
#include "Logger.h"

using namespace spades;

bool
CLangFileReader::processLine(std::istrstream& line,
                             const char* fileid,
                             const char* path,
                             float version)
{
  SorterMsgBuilder sorter_msg_builder(&mqueue);
  rcss::clang::Parser clang_parser(sorter_msg_builder);

  try {

    // I do this downcast so that the compilier doesn't try to for istrstream to become const char*
    if (!((rcss::Parser*)&clang_parser)->parse(line) )
      {
        errorlog << "CLangFileReader: Could not parse line from " << fileid << ende;
        return false;
      }
    else
      {
        //TEST CODE:
        //std::cout << "Parsed line: " << line << endl;
      }
  }
  catch( rcss::clang::BuilderErr e)
    { errorlog << "Error parsing file " << fileid << ": " << e.what() << ende; return false;}
  catch( rcss::util::NullErr e)
    { errorlog << "Error parsing file " << fileid << ": " << e.what() << ende; return false;}

  return true;
}


