/* -*- Mode: C++ -*- */
/* These classes help in manipulating binary files */

#ifndef _BINARY_FILE_H_
#define _BINARY_FILE_H_

#include <iostream>

// everything is automagically put into network byte order

class BinaryFileWriter
{
public:
  BinaryFileWriter(const char* fn);
  BinaryFileWriter(std::ostream& out);
  ~BinaryFileWriter();

  // assume a null term string
  bool writeMagicHeader(const char* header);

  bool writeChar(unsigned char c);
  bool writeShort(unsigned short s);
  bool writeInt(unsigned int i);
  bool writeLong(unsigned long l);
  bool writeFloat(float f);
  bool writeDouble(double d);

  bool writeIntAsShort(int i);
  bool writeIntAsChar(int i);
  
  bool writeString(const char* s) { return writeString(s, strlen(s)+1); }
  // exactly len bytes are written, so it's up to you to include the trailing NULL
  bool writeString(const char* s, unsigned len);
  bool writeString(std::string s) { return writeString(s.c_str(), s.length()+1); }

private:

  //not defined
  BinaryFileWriter(const BinaryFileWriter&);
  //not defined
  const BinaryFileWriter& operator=(const BinaryFileWriter&);
  
  std::ofstream* poutfile;
  std::ostream& out;
};

class BinaryFileReader
{
public:
  BinaryFileReader(const char* fn);
  BinaryFileReader(std::istream& in);
  ~BinaryFileReader();

  // assume a null term string
  bool checkMagicHeader(const char* header);

  bool readChar(char* pc);
  bool readChar(unsigned int* pi)
  { char c; if (!readChar(&c)) return false; *pi = static_cast<unsigned int>(c); return true; }
  bool readChar(signed int* pi)
  { char c; if (!readChar(&c)) return false; *pi = static_cast<signed int>(c); return true; }
  bool readShort(unsigned short* ps);
  bool readShort(signed short* ps) { return readShort(reinterpret_cast<unsigned short*>(ps)); }
  bool readShort(unsigned int* pi)
  { unsigned short s; if (!readShort(&s)) return false; *pi = static_cast<unsigned int>(s); return true; }
  bool readShort(signed int* pi)
  { signed short s; if (!readShort(&s)) return false; *pi = static_cast<signed int>(s); return true; }
  bool readInt(unsigned int *pi);
  bool readInt(signed int *pi) { return readInt(reinterpret_cast<unsigned int*>(pi)); }
  bool readLong(unsigned long *pl);
  bool readLong(signed long *pl) { return readLong(reinterpret_cast<unsigned long*>(pl)); }
  bool readFloat(float *pf);
  bool readFloat(double *pd)
  { float f; if (!readFloat(&f)) return false; *pd = static_cast<double>(f); return true; }
  bool readDouble(double *pd);

  //returns number of chars read. May or may not be null-term
  int readString(char* s, unsigned buffer_size);
  bool readString(std::string* ps);

private:
  //not defined
  BinaryFileReader(const BinaryFileReader&);
  //not defined
  const BinaryFileReader& operator=(const BinaryFileReader&);

  std::ifstream* pinfile;
  std::istream& in;
};




#endif
