/* -*- Mode: C++ -*- */

#ifndef _ABMDP_H_
#define _ABMDP_H_

#include <iostream>
#include "PlayerOccupancy.h"
#include "AbstractState.h"
#include "CoachMessageQueue.h"
#include "SoccerModelWValue.h"

// THis class is designed to encapsulate the use of advice by mdp generation
class ABMDP
{
public:
  ABMDP();
  ~ABMDP();

  AbstractStateDescription* getStateDescription() { return pdesc; }
  const AbstractStateDescription* getStateDescription() const { return pdesc; }
  void setStateDescription(AbstractStateDescription* p);

  bool readMDPAndQTable(const char* mdpfn, const char* qtablefn);

  void addStateFilter(SoccerStateFilter* p) { lfilters_state.push_back(p); }
  void addActionFilter(SoccerActionFilter* p) { lfilters_act.push_back(p); }
  
  char getLeadingChar() const { return rules_leading_char; }
  void setLeadingChar(char c) { rules_leading_char = c; }
  const std::string& getTopRuleName() const { return top_rule_name; }
  void setTopRuleName(const std::string& s) { top_rule_name = s; }

  //%C will be replaced with leading char
  const std::string& getTreeAssocFN() const { return tree_assoc_fn; }
  void setTreeAssocFN(const std::string& s) { tree_assoc_fn = s; }
  
  void generateAdvice(CoachMessageQueue& mqueue);
  void setState(CoachMessageQueue& mqueue, bool state);
  
private:
  AdviceTree* createAdviceTree();
  
  AbstractStateDescription* pdesc;
  SoccerModelWValue soccer_model;
  
  std::list<SoccerStateFilter*> lfilters_state;
  std::list<SoccerActionFilter*> lfilters_act;

  char rules_leading_char;
  std::string top_rule_name;

  std::string tree_assoc_fn;
  
  AdviceTree* p_advice_tree;
};



#endif
