// -*-c++-*-

/***************************************************************************
                               rcssexceptions.h
                               exceptions for rcss
                             -------------------
    begin                : 27-JUN-2002
    copyright            : (C) 2002 by The RoboCup Soccer Server
                           Maintenance Group.
    email                : sserver-admin@lists.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU LGPL as published by the Free Software  *
 *   Foundation; either version 2 of the License, or (at your option) any  *
 *   later version.                                                        *
 *                                                                         *
 ***************************************************************************/

#ifndef _RCSS_EXCEPTIONS_
#define _RCSS_EXCEPTIONS_

#include <exception>
#include <string>
#include <strstream>

namespace rcss
{
  namespace util
  {
    class NullErr
         : public std::exception
    {
    protected:
      std::string M_msg;
    public:
      NullErr ( const char* file, const int& line, const char* msg )
      {
        std::ostrstream tmp;
        tmp << file << ": " << line << ": " << msg << std::ends;
     
        M_msg = tmp.str ();
        tmp.freeze ( false );
      }
    
    ~NullErr () throw ()
    {
    }
    
    const char*
    what () const throw ()
    { return M_msg.c_str (); }
        
    };
  }
}
#endif
    
