/*
 * John Davin
 * A storage class for coach messages
 *
 */

#ifndef MSG_STORE_H
#define MSG_STORE_H

#include <map>
#include <string>
#include "clangmsg.h"
#include "rule.h"
#include "config.h"

template <class T>
class MsgStore {


 protected: 
  // the storage container for all the msgs we receive: 
  typedef std::map<std::string, T> Storage;
  
  Storage messages;
  // we'll use the default comparison function for now


 public: 

  typedef typename Storage::const_iterator MsgIterator;

  bool add(const std::string &msgstr, const T &msg)
    {
      /* First inspect storage and see if an object with the same name
	 already exists.... */
      T msgtest;
      bool exists = lookup(msgstr, &msgtest);

      /* If the message existed in the storage, free the memory held by
	 the pointer */
      if(exists)
	delete msgtest;

      /* Assign the message into the message store */
      messages[msgstr] = msg;


      //PR(10, "[MsgStore]: added message to map\n");
      
      /* Tells whether the object with the name has been added for the first
	 time or not. True if the object was added more than once, false
	 if it's the first time */
      return exists;
    }

  /*
   * Given a name, return the instance that it maps to
   * Return NULL if message not found. 
   */
  bool lookup(const std::string &name, T *returnval)
    {
      MsgIterator it = messages.find(name);
      if(it == messages.end())
	return false;
      else{
	*returnval = (*it).second;
	return true;
      }

    }


  void PrintAll()
    {
      if(messages.size() == 0) return; 
      // above is just because when I tried to call PrintAll before doing an add, begin() segfaulted. 

      MsgIterator cur  = messages.begin();

      cout << "[MsgStore]: Printing message store:" << endl;
      while(cur != messages.end()){
	cout << (*cur).first.c_str() << endl;

	cur++;
      }

    }



  MsgIterator getIterBegin(){
    return messages.begin();
  }

  MsgIterator getIterEnd(){
    return messages.end();
  }


};



#endif // MSG_STORE_H
