/*
 * John Davin
 * A storage class for Rule messages
 * This is a subclass of MsgStore. 
 * This allows us to use the standard MsgStore functions but also 
 * to define extra ones that may be specific to Rule messages. 
 */

#ifndef MSG_RULE_STORE_H
#define MSG_RULE_STORE_H

#include <map.h>
#include <string.h>
#include "clangmsg.h"
#include "rule.h"
#include "config.h"
#include "msgstore.h"
#include "ActionBinding.h"



typedef struct RuleNamePtrPair{

  /* Rule name */
  std::string rulename;

  /* Pointer to the Rule object */
  Rule *ptr;
  
  /* Source of the rule */
  ActionBinding::SourceType sourceType;
  
} RulePair;


class MsgRuleStore : public MsgStore< RulePair > {

 protected: 

  struct cmp // comparison function for our set of RulePair's.
  {
    bool operator()(const RulePair r1, const RulePair r2) const
    {
      return r1.rulename < r2.rulename;
    }
  };


  // keep maps of on/off states of the rules (true=on, false=off)
  // each key holds the rule name and a pointer to the rule. 
  std::set<RulePair, cmp> onrules;
  typedef std::set<RulePair>::iterator RuleStateIter;

 public: 
  // put any additional Rule-specific functions here
  bool add(const std::string &msgstr, const RulePair &msg);

  // delete an entry. Returns number of entries deleted 
  // (1 if succeeded, 0 if failed)
  int remove(const std::string &name);

  bool TurnOn(const std::string &name);

  bool TurnOff(const std::string &name);

  void TurnOnAll();
  void TurnOffAll();

  // returns pointer to the rule if it is on, and NULL if it's off. 
  Rule *QueryState(const std::string &name);

  void EvaluateRules();

  std::ostream& print( std::ostream& o ) const;

};



#endif // MSG_RULE_STORE_H
