// -*-c++-*-

#ifndef _DELMSGBUILDER_H_
#define _DELMSGBUILDER_H_

#include "clangbuilder.h"
#include "visitor.h"
#include <stack>
#include <memory>
#include <list>


#ifdef DEBUG
#include <typeinfo>
#include <iostream>
#endif


namespace rcss
{
  namespace clang
  {
    class Msg;

    class MetaToken;
    class Action;
    class Dir;
    class Cond;
    class Token;
    class Def;
    class Region;
    class Point;
    class UNum;
    class UNumSet;
    class RuleIDList;
    class ActivateRules;
    class Rule;


    class DelMsgBuilder
      : public Builder
    {
    protected:
    public:
      DelMsgBuilder() {}

      virtual
      ~DelMsgBuilder() {}

      virtual
      void
      setVer( const unsigned int& min, const unsigned int& max ) {}

      virtual
      void
      setTime( const int& time ) {}

      virtual
      void
      setSide( const int& side ) {}
      
      virtual
      void
      setTimeRecv( const int& time ) {}

      virtual
      void
      buildMetaMsg() {}

      virtual
      void
      buildMetaTokenVer( const double& ver ) {} 

      virtual
      void
      buildDefineMsg() {}

      virtual
      void
      buildDefineCond( const std::string& name ) {}

      virtual
      void
      buildDefineDir( const std::string& name ) {}

      virtual
      void
      buildDefineReg( const std::string& name ) {}

      virtual
      void
      buildDefineAct( const std::string& name ) {}

      virtual
      void
      buildFreeformMsg( const std::string& str ) {}
      
      virtual
      void
      buildUnsuppMsg() {}

      virtual
      void  
      buildInfoMsg() {}
 
      virtual
      void
      buildAdviceMsg() {}

      virtual
      void
      buildTokenRule( const int& ttl ) {}

      virtual
      void
      buildTokenClear() {}

      virtual
      void
      buildActPos() {}

      virtual
      void
      buildActHome() {}

      virtual
      void
      buildActBallToReg() {}

      virtual
      void
      buildActBallToPlayer() {}

      virtual
      void
      buildActMark() {}

      virtual
      void
      buildActMarkLinePlayer() {}

      virtual
      void
      buildActMarkLineReg() {}

      virtual
      void
      buildActOffsideLine() {}

      virtual
      void
      buildActHetType( const int& type ) {}
 
      virtual
      void
      buildActNamed( const std::string& name ) {}

      virtual
      void
      buildActPassReg() {}

      virtual
      void
      buildActPassUNum() {}

      virtual
      void
      buildActDribble() {}

      virtual
      void
      buildActClear() {}

      virtual
      void
      buildActShoot() {}

      virtual
      void
      buildActHold() {}

      virtual
      void
      buildActIntercept() {}

      virtual
      void
      buildActTackle() {}

      virtual
      void
      buildDirComm( const bool& do_dont, const bool& our_side ) {}

      virtual
      void
      buildDirNamed( const std::string& name ) {}

      virtual
      void
      buildCondTrue() {}

      virtual
      void
      buildCondFalse() {}

      virtual
      void
      buildCondPlayerPos( const bool& our_side, 
                          const int& min, 
                          const int& max ) {}

      virtual
      void
      buildCondBallPos() {}

      virtual
      void
      buildCondBallOwner( const bool& our_side ) {}

      virtual
      void
      buildCondPlayMode( const PlayMode& play_mode ) {}

      virtual
      void
      buildCondAnd() {}

      virtual
      void
      buildCondOr() {}

      virtual
      void
      buildCondNot() {}

      virtual
      void
      buildCondNamed( const std::string& name ) {}
      
      virtual
      void
      buildCondTime( const int& time, const util::CompOp& comp ) {}

      virtual
      void
      buildCondOppGoal( const int& goals, const util::CompOp& comp ) {}

      virtual
      void
      buildCondOurGoal( const int& goals, const util::CompOp& comp ) {}

      virtual
      void
      buildCondGoalDiff( const int& goals, const util::CompOp& comp ) {}

      virtual
      void
      buildCondUNum( const rcss::clang::UNum& unum ) {}

      virtual
      void
      buildAddToCondList ( ) {}

      virtual
      void
      buildCreateCondList ( ) {}
      
      virtual
      void
      buildRegNull() {}

      virtual
      void
      buildRegQuad() {}

      virtual
      void
      buildRegArc( const double& start_rad,
                   const double& end_rad,
                   const double& start_ang,
                   const double& span_ang ) {}

      virtual
      void
      buildRegUnion() {}

      virtual
      void
      buildRegNamed( const std::string& name ) {}

      virtual
      void
      buildRegPoint() {}

      virtual
      void
      buildRegTri() {}

      virtual
      void
      buildRegRec() {}

      virtual
      void
      buildPointSimple( const double& x, const double& y ) {}

      virtual
      void
      buildPointRel( const double& x, const double& y ) {}

      virtual
      void
      buildPointBall() {}

      virtual
      void
      buildPointPlayer( const bool& our_side, const UNum& unum ) {}

      virtual
      void
      buildPointArith( const rcss::util::ArithOp& arith_op ) {}

      virtual
      void
      buildUNum( const UNum& unum ) {}
 
      virtual
      void
      buildUNumSet() {}
 
      virtual
      void
      buildBallMoveToken( const BallMoveToken& bmt ) {}     

      virtual
      void
      buildRuleMsg() {}

      virtual
      void
      buildActivateAllRules( const bool& on ) {}

      virtual
      void
      buildActivateRules( const bool& on ) {}

      virtual
      void
      buildRuleID( const std::string& id ) {}

      virtual
      void
      buildRuleIDList() {}

      virtual
      void
      buildRuleIDListALL() {}

      virtual
      void
      buildDelMsg() {}

      virtual
      void
      buildDefineModelRule( const std::string& id ) {}

      virtual
      void
      buildDefineDirectiveRule( const std::string& id ) {}

      virtual
      void
      buildSimpleRule() {}

      virtual
      void
      buildNestedRule() {}

      virtual
      void
      buildIDRule() {}
    };
  }
  
}

#endif
