// -*-c++-*-

/***************************************************************************
                                 clanglexer.h
                               Lexer for CLang
                             -------------------
    begin                : 27-JUN-2002
    copyright            : (C) 2002 by The RoboCup Soccer Server 
                           Maintenance Group.
    email                : sserver-admin@lists.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU LGPL as published by the Free Software  *
 *   Foundation; either version 2 of the License, or (at your option) any  *
 *   later version.                                                        *
 *                                                                         *
 ***************************************************************************/

#ifndef CLANGLEXER_H
#define CLANGLEXER_H

#include "tuple.h"
#include "compop.h"
#include "arithop.h"
#include "clangutil.h"

#undef yyFlexLexer
#define yyFlexLexer RCSSCLangFLexLexer
#include <rcssbase/FlexLexer.h>

class RCSSCLangLexer
  : public RCSSCLangFLexLexer
{
public:
  /* This used to be a tuple type. However, since bison generates C code
     the destructors won't be called and tuple will leak memory */
  typedef struct
  {
    int i;
    double d;
    std::string* ps;
    rcss::clang::BallMoveToken bmt;
    rcss::clang::PlayMode pm;
    bool b;
    const rcss::util::CompOp* cop;
    const rcss::util::ArithOp* aop;
  } Holder;
  
  
  virtual
  int
  yylex(); // defined in coach_lang_tok.cc
  
  inline
  int
  lex( Holder& holder )
  { M_lexed_val = &holder; return yylex(); }

private:
  Holder* M_lexed_val;
};

namespace rcss
{
  namespace clang
  {
    typedef RCSSCLangLexer Lexer;
  }
}

#endif
