// -*-c++-*-

/***************************************************************************
                                clangmetamsg.cc 
                       Class for CLang Meta messages
                             -------------------
    begin                : 28-MAY-2002
    copyright            : (C) 2002 by The RoboCup Soccer Server 
                           Maintenance Group.
    email                : sserver-admin@lists.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU LGPL as published by the Free Software  *
 *   Foundation; either version 2 of the License, or (at your option) any  *
 *   later version.                                                        *
 *                                                                         *
 ***************************************************************************/

#include "clangmetamsg.h"
#include "types.h"

namespace rcss
{
  namespace clang
  {
    void
    MetaToken::TypeExtractor::visit( MetaTokenVer* tok )
    { setValue( tok ); }

    void
    MetaToken::ConstTypeExtractor::visit( const MetaTokenVer* tok )
    { setValue( tok ); }
 
    MetaToken::MetaToken()
    {}
  
    MetaToken::~MetaToken()
    {}

    MetaTokenVer::MetaTokenVer( const double& ver ) 
      : MetaToken(),
        HasADouble( ver )
    {}

    MetaTokenVer::~MetaTokenVer()
    {}

    std::auto_ptr< MetaToken >
    MetaTokenVer::deepCopy() const
    { return std::auto_ptr< MetaToken >( new MetaTokenVer( *this ) ); } 

    void
    MetaTokenVer::accept( Visitor& v )
    { v.startVisit( this ); }
    
    void
    MetaTokenVer::accept( ConstVisitor& v ) const
    { v.startVisit( this ); }
    
    std::ostream& 
    MetaTokenVer::print( std::ostream& out ) const
    { return out << "(ver " << getRef() << ")"; }
    
    std::ostream&
    MetaTokenVer::printPretty( std::ostream& out, const std::string& line_header ) const
    { return out << line_header << "version: " << getRef() << std::endl; }
    
    double
    MetaTokenVer::getVer() const 
    { return get(); }




    MetaMsg::MetaMsg() 
      : Msg()
    {}
      
    MetaMsg::MetaMsg( const Storage& tokens ) 
      : Msg(),
        HasManyTokens( tokens )
    {}

    MetaMsg::~MetaMsg()
    {}
      
    std::auto_ptr< Msg >
    MetaMsg::deepCopy() const
    { return std::auto_ptr< Msg >( new MetaMsg( *this ) ); }

    void
    MetaMsg::accept( Visitor& v )
    { v.startVisit( this ); }

    void
    MetaMsg::accept( ConstVisitor& v ) const
    { v.startVisit( this ); }

    std::ostream& 
    MetaMsg::print( std::ostream& out ) const
    {
      out << "(meta";
      for( Storage::const_iterator token_iter = get().begin();
           token_iter != get().end();
           ++token_iter )
        {
          if( *token_iter == NULL )
            out << " (null)";
          else
            out << " " << **token_iter;
        }
      out << ")";
      return out;
    }

    std::ostream& 
    MetaMsg::printPretty( std::ostream& out, const std::string& line_header ) const
    {
      out << line_header << "Meta" << std::endl;

      for( Storage::const_iterator token_iter = get().begin();
           token_iter != get().end(); ++token_iter) 
        {
          if( *token_iter == NULL )
            out << line_header << " - (null)\n";
          else
            (*token_iter)->printPretty( out, line_header + " - " );
        }
      return out;
    }

    MetaMsg::Storage&
    MetaMsg::getTokens()
    { return get(); }

    const MetaMsg::Storage&
    MetaMsg::getTokens() const
    { return get(); }
  }
}
