// -*-c++-*-

/***************************************************************************
                                clangdefmsg.cc  
                       Class for CLang Define messages
                             -------------------
    begin                : 28-MAY-2002
    copyright            : (C) 2002 by The RoboCup Soccer Server 
                           Maintenance Group.
    email                : sserver-admin@lists.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU LGPL as published by the Free Software  *
 *   Foundation; either version 2 of the License, or (at your option) any  *
 *   later version.                                                        *
 *                                                                         *
 ***************************************************************************/

#include "clangdefmsg.h"
#include "types.h"

namespace rcss
{
  namespace clang
  {
    DefineMsg::DefineMsg() 
      : Msg(),
        HasManyDefs()
    {}
    
    DefineMsg::DefineMsg( const Storage& defs ) 
      : Msg(),
        HasManyDefs( defs )
    {}
    
    DefineMsg::~DefineMsg()
    {}
    
    std::auto_ptr< Msg >
    DefineMsg::deepCopy() const
    { return std::auto_ptr< Msg >( new DefineMsg( *this ) ); }
    
    void
    DefineMsg::accept( Visitor& v )
    { v.startVisit( this ); }
    
    void
    DefineMsg::accept( ConstVisitor& v ) const
    { v.startVisit( this ); }
    
    std::ostream&
    DefineMsg::print( std::ostream& out ) const
    {
      out << "(define";
      for( Storage::const_iterator token_iter = get().begin(); 
           token_iter != get().end(); ++token_iter )
        {
          if( *token_iter == NULL )
            out << " (null)";
          else
            out << " " << **token_iter;
        }
      out << ")";
      return out;
    }

    std::ostream&
    DefineMsg::printPretty( std::ostream& out,
                            const std::string& line_header ) const
    {
      out << line_header << "Define" << std::endl;
      for( Storage::const_iterator token_iter = get().begin(); 
           token_iter != get().end(); ++token_iter )
        {
          if( *token_iter == NULL )
            out << line_header << " - (null)\n";
          else
            (*token_iter)->printPretty( out, line_header + " - " );
        }
      return out;
    }

    const DefineMsg::Storage& 
    DefineMsg::getTokens() const
    { return get(); }
  }
}
