/* Dongryeol Lee
 *
 * RegionIterator.h
 * This file defines the abstract base class for region iterator for all
 * region types
 */

#include "Geometry.h"
#include "WorldModelInterface.h"
#include "VarBindings.h"


#ifndef REGITERATOR
#define REGITERATOR

class RegionIterator
{
 public:
  
  /* Some constructors */
  RegionIterator()
    {
      /* By default, the distance between each successive points is 1.0 */
      dist_pt = 1.0;
    }

  RegionIterator(double dist)
    {
      dist_pt = dist;
    }

  virtual ~RegionIterator() {}
  
  virtual VecPosition getPt(RegionWorldModelInterface *wmi, 
			    const VarBindings& s) = 0;
  
  virtual void moveToNextPt() = 0;

  virtual void resetToBegin() = 0;

  bool valid()
    { return !error_flag; }

 protected:
  double dist_pt;
  bool error_flag;
};

#endif
