#include "rule.h"
#include "ClangCallBack.h"
#include <string.h>


#ifndef NAMED_OBJECT_UPDATE
#define NAMED_OBJECT_UPDATE


class NamedObjectUpdate: public ClangCallBack
{

 public:
  /* Named object type to be updated */
  enum UpdateType { REGION, COND, RULE, ACTION, DIR };

 private:

  /* Type of the object to be updated */
  UpdateType uType;

  /* Name to be updated */
  std::string name;

  /* Pointer for updating region type */
  Region *pReg;

  /* Pointer for updating cond type */
  Cond *pCond;

  /* Pointer for updating rule type */
  Rule *pRule;

  /* Pointer for updating action type */
  Action *pAct;

  /* Poitner for updating dir type */
  Dir *pDir;


 public: 

  NamedObjectUpdate(): ClangCallBack() {}

  /* 5 overloaded constructors */
  NamedObjectUpdate(UpdateType ut, const std::string &regname, Region *p): 
    ClangCallBack(), uType(ut), name(regname), pReg(p) 
    {}

  NamedObjectUpdate(UpdateType ut, const std::string &condname, Cond *p): 
    ClangCallBack(), uType(ut), name(condname), pCond(p)
    {}

  NamedObjectUpdate(UpdateType ut, const std::string &rulename, Rule *p): 
    ClangCallBack(), uType(ut), name(rulename), pRule(p)
    {}

  NamedObjectUpdate(UpdateType ut, const std::string &actname, Action *p): 
    ClangCallBack(), uType(ut), name(actname), pAct(p)
    {}

  NamedObjectUpdate(UpdateType ut, const std::string &dirname, Dir *p): 
    ClangCallBack(), uType(ut), name(dirname), pDir(p)
    {}


  /* Visit methods */
  void visitRegNull(rcss::clang::RegNull *)
    {}

  void visitRegQuad(rcss::clang::RegQuad *)
    {}

  void visitRegArc(rcss::clang::RegArc *)
    {}

  void visitRegUnion(rcss::clang::RegUnion *)
    {}

  void visitRegNamed(rcss::clang::RegNamed *reg)
    {
      /* Check if we are updating the Region type */
      if( uType != REGION )
	return;

      /* Check if the name of the region is the same as the one we want to 
	 update */
      if( (reg->getName()) ==name )
	reg->setLink( pReg );
    }

  void visitRegPoint(rcss::clang::RegPoint * )
    {}
  
  void visitRegTri(rcss::clang::RegTri * )
    {}

  void visitRegRec(rcss::clang::RegRec * )
    {}

  void visitCondBool(rcss::clang::CondBool*  )
    {}

  void visitCondAnd(rcss::clang::CondAnd*  )
    {}

  void visitCondOr(rcss::clang::CondOr*  )
    {}
  
  void visitCondNot(rcss::clang::CondNot*  )
    {}
  
  void visitCondPlayerPos(rcss::clang::CondPlayerPos*  )
    {}

  void visitCondBallPos(rcss::clang::CondBallPos*  )
    {}

  void visitCondBallOwner(rcss::clang::CondBallOwner*  )
    {}
      
  void visitCondPlayMode(rcss::clang::CondPlayMode*  )
    {}
      
  void visitCondNamed(rcss::clang::CondNamed* cond)
    {
      /* Check if we are updating the Cond type */
      if( uType != COND )
	return;
      
      /* Check if the name of the Cond is the same as the one we want to 
	 update */
      if( ( cond->getName() ) == name )
	cond->setLink( pCond );
    }
  
  void visitCondTime(rcss::clang::CondTime*  )
    {}
      
  void visitCondOppGoal(rcss::clang::CondOppGoal*  )
    {}

  void visitCondOurGoal(rcss::clang::CondOurGoal*  )
    {}
      
  void visitCondGoalDiff(rcss::clang::CondGoalDiff*  )
    {}
      
  void visitCondUNum(rcss::clang::CondUNum*  )
    {}
      
  void visitSimpleRule(rcss::clang::SimpleRule * )
    {}
  
  void visitNestedRule(rcss::clang::NestedRule * )
    {}
      
  void visitCondRule(rcss::clang::CondRule * )
    {}
      
  void visitIDListRule(rcss::clang::IDListRule *rule)
    {
      /* First check if we are updating the right type. If not, don't do
	 anything more */
      if(uType != RULE)
	return;

      /* First retrieve the RuleIDList (the Rule names) */
      RuleIDList rules = rule->getIDList();
      
      /* The rule name in string form */
      RuleID rulename;
      
      /* Position */
      int pos = 0;

      /* Go through each rule name and look up that name in our rule storage */
      for( std::list< RuleID >::iterator i = rules.begin(); 
	   i != rules.end(); i++ ){
	
	/* Get our rule name */
	rulename = *i;
	
	/* If it's found, hook up the pointer */
	if(rulename == name)
	  rule->changeRule(pos, pRule);

	pos++;
      }
    }

  void visitActPos(rcss::clang::ActPos * )
    {}
      
  void visitActHome(rcss::clang::ActHome * )
    {}
      
  void visitActBallToReg(rcss::clang::ActBallToReg * )
    {}
      
  void visitActBallToPlayer(rcss::clang::ActBallToPlayer * )
    {}
      
  void visitActMark(rcss::clang::ActMark * )
    {}

  void visitActMarkLinePlayer(rcss::clang::ActMarkLinePlayer * )
    {}
      
  void visitActMarkLineReg(rcss::clang::ActMarkLineReg * )
    {}
      
  void visitActOffsidesLine(rcss::clang::ActOffsidesLine * )
    {}
      
  void visitActHetType(rcss::clang::ActHetType * )
    {}
      
  void visitActNamed(rcss::clang::ActNamed *act) 
    {
      /* Check if we are updating the Action type */
      if( uType != ACTION )
	return;
      
      /* Check if the name of the action is the same as the one we want to 
	 update */
      if( ( act->getName() ) == name )
	act->setLink( pAct );
    }
      
  void visitActPassReg(rcss::clang::ActPassReg * )
    {}
  
  void visitActPassUNum(rcss::clang::ActPassUNum * )
    {}
      
  void visitActDribble(rcss::clang::ActDribble * )
    {}
      
  void visitActClear(rcss::clang::ActClear * )
    {}
      
  void visitActShoot(rcss::clang::ActShoot * )
    {}
      
  void visitActHold(rcss::clang::ActHold * )
    {}
      
  void visitActIntercept(rcss::clang::ActIntercept * )
    {}
  
  void visitActTackle(rcss::clang::ActTackle * )
    {}
      
  void visitDirComm(rcss::clang::DirComm*  )
    {}
      
  void visitDirNamed(rcss::clang::DirNamed *dir)
    {
      /* Check if we are updating the Dir type */
      if( uType != DIR)
	return;
      
      /* Check if the name of the Dir is the same as the one we want to 
	 update */
      if( ( dir->getName() ) == name  )
	dir->setLink( pDir );
    }

};


#endif
