#include "msgstore.h"
#include "msgrulestore.h"
#include "ClangCallBack.h"
#include <string.h>


#ifndef NAMED_OBJECT_LOOKUP
#define NAMED_OBJECT_LOOKUP


/* This class provides the call back functions for adding a new Clang object
   to our player's storage for the first time. It will refer to other "named
   thingys" in the storage and link to the appropriate pointers stored in
   the player's five storages.

   Do this by declaring NamedObjectLookup object and the ClangIterator

   ClangIterator ci(nol);

   ci.iterateOn( objectToBeLinked );
*/
class NamedObjectLookup: public ClangCallBack
{
 private:

  /* Takes 5 pointers to the player's name storages */
  MsgStore <Cond*> *mycondstore;

  MsgStore <Dir*> *mydirstore;

  MsgStore <Region*> *myregstore;

  MsgStore <Action*> *myactstore;

  MsgRuleStore *myrulestore;


 public: 

  /* Constructor: Takes all 5 message storages */
  NamedObjectLookup(MsgStore <Cond*> *condstorage,
		    MsgStore <Dir*> *dirstorage,
		    MsgStore <Region*> *regstorage,
		    MsgStore <Action*> *actstorage,
		    MsgRuleStore *rulestorage):
    mycondstore(condstorage), mydirstore(dirstorage), myregstore(regstorage),
    myactstore(actstorage), myrulestore(rulestorage)
    {}

  /* Visit methods */
  void visitRegNull(rcss::clang::RegNull *)
    {}

  void visitRegQuad(rcss::clang::RegQuad *)
    {}

  void visitRegArc(rcss::clang::RegArc *)
    {}

  void visitRegUnion(rcss::clang::RegUnion *)
    {}

  void visitRegNamed(rcss::clang::RegNamed *reg)
    {
      Region *theregion;

      /* Look up the region in the region storage */
      bool found = myregstore->lookup(reg->getName(), &theregion);
      
      /* If the region is found in the storage, update to the pointer stored
	 in the region storage */
      if( found ) {

	//cout << *theregion << " found at " << theregion << "\n";
	reg->setLink(theregion);
      }

      /* Else, warning shown */
      else
	cout << "[NamedObjectLookup::visitRegNamed]: Region object not found: "
	     << reg->getName()
	     << "\n";
     }

  void visitRegPoint(rcss::clang::RegPoint * )
    {}
  
  void visitRegTri(rcss::clang::RegTri * )
    {}

  void visitRegRec(rcss::clang::RegRec * )
    {}

  void visitCondBool(rcss::clang::CondBool*  )
    {}

  void visitCondAnd(rcss::clang::CondAnd*  )
    {}

  void visitCondOr(rcss::clang::CondOr*  )
    {}
  
  void visitCondNot(rcss::clang::CondNot*  )
    {}
  
  void visitCondPlayerPos(rcss::clang::CondPlayerPos*  )
    {}

  void visitCondBallPos(rcss::clang::CondBallPos*  )
    {}

  void visitCondBallOwner(rcss::clang::CondBallOwner*  )
    {}
      
  void visitCondPlayMode(rcss::clang::CondPlayMode*  )
    {}
      
  void visitCondNamed(rcss::clang::CondNamed* cond)
    {
      Cond *namedcond;
      
      /* Look up the Cond pointer in the player's storage */
      bool found = mycondstore->lookup(cond->getName(), &namedcond);
      
      /* If the Cond object is found, appropriately link to the pointer */
      if(found) {

	//cout << *namedcond << " found at " << namedcond << "\n";
	cond->setLink(namedcond);
      }
      
      /* Else, print a warning */
      else
	cout << "[NamedObjectLookup::visitCondNamed]: Cond object not found: "
	     << cond->getName() << "\n";
    }
  
  void visitCondTime(rcss::clang::CondTime*  )
    {}
      
  void visitCondOppGoal(rcss::clang::CondOppGoal*  )
    {}

  void visitCondOurGoal(rcss::clang::CondOurGoal*  )
    {}
      
  void visitCondGoalDiff(rcss::clang::CondGoalDiff*  )
    {}
      
  void visitCondUNum(rcss::clang::CondUNum*  )
    {}
      
  void visitSimpleRule(rcss::clang::SimpleRule * )
    {}
  
  void visitNestedRule(rcss::clang::NestedRule * )
    {}
      
  void visitCondRule(rcss::clang::CondRule * )
    {}
      
  void visitIDListRule(rcss::clang::IDListRule *rule)
    {
      /* The RulePair object we are looking for */
      RulePair pair;

      /* boolean flag for telling whether the rule is found in our storage */
      bool found;

      /* Go through each rule name and look up that name in our rule storage */
      for( std::list< RuleID >::const_iterator i = rule->getIDList().begin(); 
	   i != rule->getIDList().end();
	   i++ )
	{

	  /* And look up its pointer in the storage */
	  found = myrulestore->lookup(*i, &pair);
	
	  /* If it's found, hook up the pointer */
	  if(found)
	    {
	      rule->addRule(pair.ptr);
	    }
	  else
	    {
	      /* Otherwise, print a warning */
	      cout << "[NamedObjectLookup::visitIDListRuleNamed]: Rule object "
		   << *i << " not found\n";
	      rule->addRule(NULL);
	    }
	}
    }

  void visitActPos(rcss::clang::ActPos * )
    {}
      
  void visitActHome(rcss::clang::ActHome * )
    {}
      
  void visitActBallToReg(rcss::clang::ActBallToReg * )
    {}
      
  void visitActBallToPlayer(rcss::clang::ActBallToPlayer * )
    {}
      
  void visitActMark(rcss::clang::ActMark * )
    {}

  void visitActMarkLinePlayer(rcss::clang::ActMarkLinePlayer * )
    {}
      
  void visitActMarkLineReg(rcss::clang::ActMarkLineReg * )
    {}
      
  void visitActOffsidesLine(rcss::clang::ActOffsidesLine * )
    {}
      
  void visitActHetType(rcss::clang::ActHetType * )
    {}
      
  void visitActNamed(rcss::clang::ActNamed *act) 
    {
      Action *namedact;
      
      /* Look up the Action pointer in the player's storage */
      bool found = myactstore->lookup(act->getName(), &namedact);
      
      /* If the Action object is found, appropriately link to the pointer */
      if(found) {
	//cout << *namedact << " found at " << namedact << "\n";
	act->setLink(namedact);
      }
      
      /* Else, print a warning */
      else
	cout << "[NamedObjectLookup::visitActNamed]: Action object not found: "
	     << act->getName() 
	     << "\n";
    }
      
  void visitActPassReg(rcss::clang::ActPassReg * )
    {}
  
  void visitActPassUNum(rcss::clang::ActPassUNum * )
    {}
      
  void visitActDribble(rcss::clang::ActDribble * )
    {}
      
  void visitActClear(rcss::clang::ActClear * )
    {}
      
  void visitActShoot(rcss::clang::ActShoot * )
    {}
      
  void visitActHold(rcss::clang::ActHold * )
    {}
      
  void visitActIntercept(rcss::clang::ActIntercept * )
    {}
  
  void visitActTackle(rcss::clang::ActTackle * )
    {}
      
  void visitDirComm(rcss::clang::DirComm*  )
    {}
      
  void visitDirNamed(rcss::clang::DirNamed *dir)
    {
      Dir *nameddir;
      
      /* Look up the Action pointer in the player's storage */
      bool found = mydirstore->lookup(dir->getName(), &nameddir);
      
      /* If the Dir object is found, appropriately link to the pointer */
      if(found) {
	//cout << *nameddir << " found at " << nameddir << "\n";
	dir->setLink(nameddir);
      }
      
      /* Else, print a warning */
      else
	cout << "[NamedObjectLookup::visitDirNamed]: Dir object not found"
	     << dir->getName()
	     << "\n";
    }

};


#endif
