/* -*- Mode: c++ -*- */

/*
 *Copyright:

    Copyright (C) 2002 Patrick Riley
    Copyright (C) 2001 Patrick Riley and Emil Talpes

    This file is part of the SPADES simulation system.

    The SPADES simulation system is free software; you can
    redistribute it and/or modify it under the terms of the GNU Lesser
    General Public License as published by the Free Software
    Foundation; either version 2 of the License, or (at your option)
    any later version.

    The SPADES simulation system is distributed in the hope that it
    will be useful, but WITHOUT ANY WARRANTY; without even the implied
    warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
    See the GNU Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with the SPADES simulation system; if not, write to
    the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
    Boston, MA 02111-1307 USA

 *EndCopyright:
*/


#include "Logger.h"
#include "utility.h"

using namespace std;
using namespace spades;

const spades::LogManip_ende spades::ende;

spades::Logger* spades::Logger::s_instance = NULL;

spades::DefaultTagFunction spades::Logger::tagDefault;

/****************************** DefaultTagFunction  *************************************/

std::string
spades::DefaultTagFunction::getTag (int level) const
{
  return "DEFAULTTAG(" + toString(level) + "): ";
}

std::string
spades::DefaultTagFunction::getErrorTag (int level) const
{
  return "DEFAULTERRORTAG(" + toString(level) + "): ";
}

/****************************** ErrorLog  *************************************/

const int spades::Logger::ErrorLog::ERROR_LOG_LEVEL = 0;

spades::Logger::ErrorLog&
spades::operator << (spades::Logger::ErrorLog & l, const spades::LogManip_ende & ende)
{
  cerr << endl;
  Logger::instance()->actionLogFunc (l.ERROR_LOG_LEVEL) << ende; //note that this is an ende!
  l.tag_next = true;
  return l;
}

/****************************** ActionLog  *************************************/

bool 
spades::Logger::ActionLog::openFiles(std::string logfile_dir, std::string action_log_fn)
{
  logfile.open ((logfile_dir + '/' + action_log_fn).c_str ());
  if (!logfile.is_open()) {
    errorlog << "Could not open action log file '"
	     << logfile_dir + '/' + action_log_fn << "'" << ende;
    return false;
  }
  return true;
}

Logger::ActionLog&
spades::operator << (Logger::ActionLog & l, const LogManip_ende & ende)
{
  if (l.logfile.is_open())
    l.logfile << endl;
  else
    std::cout << endl;

  l.tag_next = true;

  return l;
}


/****************************** Logger  *************************************/

Logger*
spades::Logger::instance()
{
  if (s_instance == NULL)
    {
      s_instance = new Logger;
    }
  return s_instance;
}

void
spades::Logger::removeInstance()
{
  actionlog(100) << "Removing logger" << ende;
  
  //we do things this way in case delete Logger::~Logger calls Logger::instance
  Logger* p = s_instance;
  s_instance = NULL;
  if (p)
    delete p;
}

