/* Dongryeol Lee
 *
 *
 * ClangPrintCallBack.h
 *
 * Simple ClangCallBack functor that will print out each clang object
 *
 */

#ifndef CLANG_PRINT_CALL_BACK
#define CLANG_PRINT_CALL_BACK

#include <iostream>
#include "ClangCallBack.h"


/* Overriding the parent ClangCallBack class */
class ClangPrintCallBack: public ClangCallBack
{

 public: 

  ClangPrintCallBack() 
    {
    }

  void visitRegNull(rcss::clang::RegNull *reg)
    { 
      cout << "RegNull found\n";
    }

  void visitRegQuad(rcss::clang::RegQuad *reg)
    {
      cout << "RegQuad found\n";
    }

  void visitRegArc(rcss::clang::RegArc *reg) 
    {
      cout << "RegArc found\n";
    }

  void visitRegUnion(rcss::clang::RegUnion *reg) 
    {
      cout << "RegUnion found\n";
    }

  void visitRegNamed(rcss::clang::RegNamed *reg) 
    {
      cout << "RegNamed found\n";
    }

  void visitRegPoint(rcss::clang::RegPoint *reg) 
    {
      cout << "RegPoint found\n";
    }

  void visitRegTri(rcss::clang::RegTri *reg) 
    {
      cout << "RegTri found\n";
    }

  void visitRegRec(rcss::clang::RegRec *reg) 
    {
      cout << "RegRec found\n";
    }

  void visitCondBool(rcss::clang::CondBool *cond) 
    {
      cout << "CondBool found\n";
    }

  void visitCondAnd(rcss::clang::CondAnd *cond) 
    {
      cout << "CondAnd found\n";
    }

  void visitCondOr(rcss::clang::CondOr *cond) 
    {
      cout << "CondOr found\n";
    }
      
  void visitCondNot(rcss::clang::CondNot *cond) 
    {
      cout << "CondNot found\n";
    }

  void visitCondPlayerPos(rcss::clang::CondPlayerPos *cond) 
    {
      cout << "CondPlayerPos found\n";
    }

  void visitCondBallPos(rcss::clang::CondBallPos *cond) 
    {
      cout << "CondBallPos found\n";
    }

  void visitCondBallOwner(rcss::clang::CondBallOwner *cond) 
    {
      cout << "CondBallOwner found\n";
    }
      
  void visitCondPlayMode(rcss::clang::CondPlayMode *cond) 
    {
      cout << "CondPlayMode found\n";
    }
      
  void visitCondNamed(rcss::clang::CondNamed *cond) 
    {
      cout << "CondNamed found\n";
    }
      
  void visitCondTime(rcss::clang::CondTime *cond) 
    {
      cout << "CondTime found\n";
    }
      
  void visitCondOppGoal(rcss::clang::CondOppGoal *cond) 
    {
      cout << "CondOppGoal found\n";
    }

  void visitCondOurGoal(rcss::clang::CondOurGoal *cond) 
    {
      cout << "CondOurGoal found\n";
    }
      
  void visitCondGoalDiff(rcss::clang::CondGoalDiff *cond) 
    {
      cout << "CondGoalDiff found\n";
    }
      
  void visitCondUNum(rcss::clang::CondUNum *cond) 
    {
      cout << "CondUNum found\n";
    }
      
  void visitSimpleRule(rcss::clang::SimpleRule *rule) 
    {
      cout << "SimpleRule found\n";
    }
  
  void visitNestedRule(rcss::clang::NestedRule *rule) 
    {
      cout << "NestedRule found\n";
    }
      
  void visitCondRule(rcss::clang::CondRule *rule) 
    {
      cout << "CondRule found\n";
    }
      
  void visitIDListRule(rcss::clang::IDListRule *rule) 
    {
      cout << "IDListRule found\n";
    }

  void visitActPos(rcss::clang::ActPos *act) 
    {
      cout << "ActPos found\n";
    }
      
  void visitActHome(rcss::clang::ActHome *act) 
    {
      cout << "ActHome found\n";
    }
      
  void visitActBallToReg(rcss::clang::ActBallToReg *act) 
    {
      cout << "ActBallToReg found\n";
    }
      
  void visitActBallToPlayer(rcss::clang::ActBallToPlayer *act) 
    {
      cout << "ActBallToPlayer found\n";
    }
      
  void visitActMark(rcss::clang::ActMark *act) 
    {
      cout << "ActMark found\n";
    }

  void visitActMarkLinePlayer(rcss::clang::ActMarkLinePlayer *act) 
    {
      cout << "ActMarkLinePlayer found\n";
    }
      
  void visitActMarkLineReg(rcss::clang::ActMarkLineReg *act) 
    {
      cout << "ActMarkLineReg found\n";
    }
      
  void visitActOffsidesLine(rcss::clang::ActOffsidesLine *act) 
    {
      cout << "ActOffsidesLine found\n";
    }
      
  void visitActHetType(rcss::clang::ActHetType *act) 
    {
      cout << "ActHetType found\n";
    }
      
  void visitActNamed(rcss::clang::ActNamed *act) 
    {
      cout << "ActNamed found\n";
    }
      
  void visitActPassReg(rcss::clang::ActPassReg *act) 
    { 
      cout << "ActPassReg found\n";
    }
      
  void visitActPassUNum(rcss::clang::ActPassUNum *act) 
    {
      cout << "ActPassUNum found\n";
    }
      
  void visitActDribble(rcss::clang::ActDribble *act) 
    {
      cout << "ActDribble found\n";
    }
      
  void visitActClear(rcss::clang::ActClear *act) 
    {
      cout << "ActClear found\n";
    }
      
  void visitActShoot(rcss::clang::ActShoot *act) 
    {
      cout << "ActShoot found\n";
    }
      
  void visitActHold(rcss::clang::ActHold *act) 
    {
      cout << "ActHold found\n";
    }
      
  void visitActIntercept(rcss::clang::ActIntercept *act) 
    {
      cout << "ActIntercept found\n";
    }
      
  void visitActTackle(rcss::clang::ActTackle *act) 
    {
      cout << "ActTackle found\n";
    }
      
  void visitDirComm(rcss::clang::DirComm *dir) 
    {
      cout << "DirComm found\n";
    }
      
  void visitDirNamed(rcss::clang::DirNamed *dir) 
    {
      cout << "DirNamed found\n";
    }

};

#endif
