/* Dongryeol Lee
 *
 * ClangCallBack.h
 *
 * This is the parent functor class that has various visit methods for
 * clang objects. This class can be extended and all methods can be overridden
 * to define a more sophisticated class with specific purposes. This class
 * is passed to ClangIterator to add more function
 *
 */


#ifndef CLANG_CALL_BACK
#define CLANG_CALL_BACK

#include "region.h"
#include "cond.h"
#include "rule.h"
#include "clangaction.h"
#include "coach_lang_comp.h"


class ClangCallBack
{

 public: 

  ClangCallBack() {}
  virtual ~ClangCallBack() {}

  virtual void visitRegNull(rcss::clang::RegNull *) = 0;

  virtual void visitRegQuad(rcss::clang::RegQuad *) = 0;

  virtual void visitRegArc(rcss::clang::RegArc *) = 0;

  virtual void visitRegUnion(rcss::clang::RegUnion *) = 0;

  virtual void visitRegNamed(rcss::clang::RegNamed * ) = 0;

  virtual void visitRegPoint(rcss::clang::RegPoint * ) = 0;

  virtual void visitRegTri(rcss::clang::RegTri * ) = 0;

  virtual void visitRegRec(rcss::clang::RegRec * ) = 0;

  virtual void visitCondBool(rcss::clang::CondBool*  ) = 0;

  virtual void visitCondAnd(rcss::clang::CondAnd*  ) = 0;

  virtual void visitCondOr(rcss::clang::CondOr*  ) = 0;
      
  virtual void visitCondNot(rcss::clang::CondNot*  ) = 0;

  virtual void visitCondPlayerPos(rcss::clang::CondPlayerPos*  ) = 0;

  virtual void visitCondBallPos(rcss::clang::CondBallPos*  ) = 0;

  virtual void visitCondBallOwner(rcss::clang::CondBallOwner*  ) = 0;
      
  virtual void visitCondPlayMode(rcss::clang::CondPlayMode*  ) = 0;
      
  virtual void visitCondNamed(rcss::clang::CondNamed*  ) = 0;
      
  virtual void visitCondTime(rcss::clang::CondTime*  ) = 0;
      
  virtual void visitCondOppGoal(rcss::clang::CondOppGoal*  ) = 0;

  virtual void visitCondOurGoal(rcss::clang::CondOurGoal*  ) = 0;
      
  virtual void visitCondGoalDiff(rcss::clang::CondGoalDiff*  ) = 0;
      
  virtual void visitCondUNum(rcss::clang::CondUNum*  ) = 0;
      
  virtual void visitSimpleRule(rcss::clang::SimpleRule * ) = 0;
  
  virtual void visitNestedRule(rcss::clang::NestedRule * ) = 0;
      
  virtual void visitCondRule(rcss::clang::CondRule * ) = 0;
      
  virtual void visitIDListRule(rcss::clang::IDListRule * ) = 0;

  virtual void visitActPos(rcss::clang::ActPos * ) = 0;
      
  virtual void visitActHome(rcss::clang::ActHome * ) = 0;
      
  virtual void visitActBallToReg(rcss::clang::ActBallToReg * ) = 0;
      
  virtual void visitActBallToPlayer(rcss::clang::ActBallToPlayer * ) = 0;
      
  virtual void visitActMark(rcss::clang::ActMark * ) = 0;

  virtual void visitActMarkLinePlayer(rcss::clang::ActMarkLinePlayer * ) = 0;
      
  virtual void visitActMarkLineReg(rcss::clang::ActMarkLineReg * ) = 0;
      
  virtual void visitActOffsidesLine(rcss::clang::ActOffsidesLine * ) = 0;
      
  virtual void visitActHetType(rcss::clang::ActHetType * ) = 0;
      
  virtual void visitActNamed(rcss::clang::ActNamed * ) = 0;
      
  virtual void visitActPassReg(rcss::clang::ActPassReg * ) = 0;
      
  virtual void visitActPassUNum(rcss::clang::ActPassUNum * ) = 0;
      
  virtual void visitActDribble(rcss::clang::ActDribble * ) = 0;
      
  virtual void visitActClear(rcss::clang::ActClear * ) = 0;
      
  virtual void visitActShoot(rcss::clang::ActShoot * ) = 0;
      
  virtual void visitActHold(rcss::clang::ActHold * ) = 0;
      
  virtual void visitActIntercept(rcss::clang::ActIntercept * ) = 0;
      
  virtual void visitActTackle(rcss::clang::ActTackle * ) = 0;
      
  virtual void visitDirComm(rcss::clang::DirComm*  ) = 0;
      
  virtual void visitDirNamed(rcss::clang::DirNamed*  ) = 0;

};

#endif










