/*
 * Dongryeol Lee
 *
 * ActionBinding.h
 *
 * This wrapper class holds an action pointer and a list of variable bindings 
 * for that action. 
 *
 */


#ifndef ACTIONBINDING
#define ACTIONBINDING

#include "clangmsgbuilder.h"
#include "clangaction.h"
#include "VarBindings.h"


using namespace rcss::clang;


 
class ActionBinding {

 public:

  /* The action */
  Action *theaction;

  /* Variable bindings for the action */
  VarBindings myBindings;

  /* Type of allowable sources of the level */
  enum SourceType {DEFAULT, RULEFILE, COACH, ANY};

  /* Source of the action binding */
  SourceType sourceType;


  /* Constructors */
  ActionBinding()
    {}

  
  ActionBinding(Action *a)
    : theaction(a), sourceType(DEFAULT)
    {}
  

  ActionBinding(Action *a, const VarBindings& b, SourceType source)
    : theaction(a), myBindings(b), sourceType(source)
    {}
  

};

#endif


