#!/usr/local/bin/perl -w

# This script prunes the list of matched rules (such as produced by combine_matched_files
# based a list of players (such as produced by the coach ModFeature::logBallOwner/Possessor
# mode as run by find_ball_owners.pl

$usage = "$0 <player list fn> <side=left|right> <matched rules fn>";

$cmdline = join ' ', @ARGV;

$player_list_fn = shift @ARGV;
$targetside = shift @ARGV;
$matched_rules_fn = shift @ARGV;
die $usage unless (defined($player_list_fn) && 
		   defined($targetside) && 
		   defined($matched_rules_fn));
$targetside = lc($targetside);

# we'll fill up @players with nubmers representing which players are in the players list
# file. A players p is include at time t iff (players[t] & (1<<p))
open (PLFH, "<$player_list_fn") || die "Could not open player list file '$player_list_fn': $!";
$plcount = 0;
while (<PLFH>)
  {
    # format of each line is <time> <list of [side=<side>,num=<num>]>
    chomp;
    s/\#.*//;
    next if (/^\s*$/);
    /^\s*(\d+)\s*/g || die "Malformatted line '$_'";
    $time = $1;
    $players[$time] = 0;
    while (/\G\s*\[side=(\w+),num=(\d+)\]/g)
      {
	$side = lc($1);
	$num = $2;
	next if ($side ne $targetside);
	$players[$time] |= (1<<$num);
	$plcount++;
	#print "time $time, adding $num\n";
      }
  }

$pwd = `pwd`;
chomp $pwd;
print <<EOH;
# This file was generated by prune_matched.pl
# Command line: $cmdline
# Working dir: $pwd
# Total Players in input file: $plcount
EOH

open (MATCHFH, "<$matched_rules_fn") || die "Could not open matched rules file '$matched_rules_fn': $!";
while (<MATCHFH>)
  {
    # format of each line os <time>: <list of <rule name> <player mask>>
    chomp;
    s/\#.*//;
    next if (/^\s*$/);
    /^\s*(\d+)\s*:\s+/g || die "Malformatted line '$_'";
    $time = $1;
    next if ($time == 0 || $time == 3000);
    print "$time: ";
    defined ($players[$time]) || die "Undefined players at time $time";
    while (/\G\s*(\w+)\s+(\d+)\s+/g)
      {
	$rule = $1;
	$playermask = oct("0b$2");
	#print "$time $rule $playermask $players[$time]\n";
	$thismask = ($playermask & $players[$time]);
	next if ($thismask == 0);
	printf "%s %b ", $rule, $thismask;
      }
    print "\n";
  }
