#!/usr/local/bin/perl5 -w

# This script reads in results files and generates files to be used by prepare_matlab_sig.pl

use File::Basename;
#use Cwd qw(abs_path);

foreach $fn (@ARGV) {

  @scores = ();

  print STDERR "Processing $fn\n";
  print STDOUT "Processing $fn\n";

  open (INFH, "<$fn") || die "Could not open file '$fn': $!";

  while (<INFH>) {
    s/\#.*//;
    next if (/^\s*$/);
    (undef, undef, $lscore, $rscore) = split;
    push @scores, ($lscore-$rscore);
  }

  close(INFH);

  $outputfn = dirname($fn)."/score_diff.csv";
  open (OUTFH, ">$outputfn") || die "Could not open output file '$outputfn': $!";
  print OUTFH (join ' , ', @scores);
  close(OUTFH);
}



