#!/usr/local/bin/perl5 -w

# This perl script plots a PlayerOccupancy track summary file (which could have been
#  combined with combine_potrack.pl)

$usage = "Usage: $0 <list of potrack summ files>";

(@ARGV > 0) || die $usage;

foreach $fn (@ARGV) {
  $outfn = "$fn.eps";
  open (GPPROC, "|gnuplot") || die "Could not open gnuplot process: $!";

  print GPPROC <<EOF;
set term postscript eps color

set output '$outfn'
set title 'PlayerOccupancy summary: $fn'
set xlabel 'State'
set ylabel 'log(counts+1)+1'
set yrange [0:]
#set xrange [0:255]

plot '$fn' using 1:((log (\$2+1))+1) '\%lf:\%lf' notitle with impulses lw 1
EOF

  close (GPPROC);
}
