#!/usr/local/bin/perl -w

# This script take a data file generated by ModAbstract::analyzePercentOpt
# and plots it

$usage = "$0 <in fn> [<out fn>]";

$infn = shift @ARGV;
$outfn = shift @ARGV;

die $usage if (not defined($infn));

if (not defined($outfn))
  {
    $outfn = $infn;
    $outfn =~ s/\.data$//;
    $outfn .= '.eps';
  }

open (GP, "|gnuplot") || die "Could not open gnuplot process";

print GP <<EOF;

set term postscript eps color solid "Helvetica" 12
set output '$outfn'

set size 1.0

set title '$infn'

#set key graph 0.12,0.93 Left reverse
set xlabel 'Num Actions'
set ylabel 'Num Stats with these actions'

plot '$infn' using 1:3 notitle with impulses lw 10

!epstopdf $outfn
EOF

close(GP);
