#!/usr/local/bin/perl -w

# Takes a list of states and encodes them as a gif movie

use File::Basename;
use Cwd qw(abs_path);
use FileHandle;

$usage = "$0 <delay in 1/100sec> <state file> [<output .gif>]";

$delay = shift @ARGV;
$statefn = shift @ARGV;
$outfn = shift @ARGV;
die $usage unless (defined($statefn) && defined($delay));
if (not defined($outfn))
  {
    $outfn = $statefn;
    $outfn =~ s/\.log$//;
    $outfn .= '.gif';
  }
($outfn =~ /\.gif$/) || die "Out file name must end in .gif '$outfn'";

(`which gifsicle` ne '') || die "Must have gifsicle installed: http://www.lcdf.org/gifsicle/";

autoflush STDOUT 1;

open (STATEFH, "<$statefn") || die "Could not open state file '$statefn': $!";

$pwd = `pwd`;
chomp $pwd;
$tmpdir = "$pwd/TMP_msm.$$";
mkdir $tmpdir;

$fulloutfn = abs_path(dirname($outfn)) . "/" . basename($outfn);
$coachdir = dirname($0) . "/../coach";
chdir $coachdir || die "Could not change directory '$coachdir': $!";

print "Generating images: ";

$img_idx = 0;
@img = ();
while (<STATEFH>)
  {
    s/\#.*//;
    next if (/^\s*$/);

    # We'll support two formats. One entry per line is just a state number
    # more than one, then the second number is the state (like from abmdp_track.log)
    @vals = split;
    die "What is vals" if (@vals == 0);
    $state_idx = $vals[0] if (@vals == 1);
    $state_idx = $vals[1] if (@vals > 1);

    $imgfn = "$tmpdir/img.${state_idx}.${img_idx}"; # a png gets added
    $imgfn_png = "${imgfn}.png";
    $imgfn_gif = "${imgfn}.gif";
    system "./coach --file coach.conf --file all_off.conf --run_mode single --use_mod_abstract --abstract_draw_states --abstract_draw_state_num $state_idx --abstract_draw_state_out_fpat $imgfn > /dev/null";
    system "convert ${imgfn_png} ${imgfn_gif}";
    push @img, "${imgfn_gif}";
    unlink $imgfn_png;
    ++$img_idx;

    print "." if ($img_idx % 10 == 0);
  }

print "\nConverting to animated gif...\n";

#system ("convert -delay $delay " . (join ' ', @img) . " $fulloutfn");
system ("gifsicle --merge --optimize --delay $delay " . (join ' ', @img) . " > $fulloutfn");

system "rm $tmpdir/*";
system "rmdir $tmpdir";
