#!/usr/local/bin/perl -w

# this script runs the coach on a bunch of logfiles and learns the formation used

#usage: learn_formations.pl <team_dir>

use File::Copy;
use File::Basename;
use Cwd qw(abs_path);

$scriptdir = abs_path(dirname($0));
$coachdir = "$scriptdir/../coach";

$usage = "$0 <output_form_fn> <team> <logfile list> [if <team> is left or side, side is assumed]";


$output_fn = shift @ARGV;
$team = shift @ARGV;
die $usage unless (defined($output_fn && defined($team)));

$output_fn = abs_path(dirname($output_fn)) . '/' . (basename($output_fn));

@abs_logfiles = map { abs_path(dirname($_)) . '/' . basename($_) } @ARGV;

$sidesel_arg = 
  (lc($team) eq 'left' || lc($team) eq 'right') ?
  "--formation_side_to_learn $team" :
  "--formation_team_to_learn $team";

#$tmpdir = "/tmp/formation_learn.$$";
$tmpdir = "/usr0/pfr/tmp/formation_learn.$$";

mkdir $tmpdir, 0777 || die "Could not make tmp directory '$tmpdir': $!";

chdir $coachdir || die "Could not change to coach directory '$coachdir': $!";
$coach_args = "--file coach.conf --file all_off.conf ".
  "--use_mod_formation --formation_list_fn /dev/null ";
$datafile = "$tmpdir/$team";
foreach $file (@abs_logfiles) {
  $cmdline = "coach $coach_args --run_mode logfile --logfile_fn $file ".
      "--formation_gather_data $sidesel_arg ".
      "--formation_learn_data_fn $datafile --formation_draw off ";
    print "$cmdline\n";
    system $cmdline;
}
$cmdline = "coach $coach_args --run_mode single ".
  "--formation_learn_data_fn $datafile --formation_combine_data --formation_learn ".
  "--formation_learn_output_fn $output_fn ".
  "--formation_draw on --formation_draw_output_dir ". (dirname($output_fn));
print "$cmdline\n";
system $cmdline;

unlink $datafile || die "Could not unlink data file '$datafile': $!";

rmdir $tmpdir || die "Could not remove tmp dir '$tmpdir': $!";

