#!/bin/sh

# I took this from the cmu01 dir

set -x

mv -f death_check death_check.old
#mv -f missed_check missed_check.old
mv -f results results.old
#mv -f osetplay.log osetplay.log.old
# mv the directories to tmp names first to avoid collision issues
rename_consec.pl TMP 0 `find . -maxdepth 1 -type d -name \* -not -name BAD -not -name EXTRA -not -name IMAGES`
rename_consec.pl game 0 `find . -maxdepth 1 -type d -name \* -not -name BAD -not -name EXTRA -not -name IMAGES`
check_players_lived.pl */*.rcl.gz > death_check

find_coach_timeout.pl */server_stderr.log.gz > coach_death_check

check_missed_cycles.pl */*rcl.gz
combine_datafiles.pl */missed_cycles.log > all_missed_cycles.log

svtool -r */*.rcg.gz > results
compute_average_score.pl results >> results

extract_coach_errors.pl game*/server_stderr.log.gz > coach_errors

prepare_score_diff.pl results

find_ball_owners.pl game*/*rcg.gz

extract_rule_actions.pl game*/*rcg.gz

ls `pwd`/*/*rcg.gz > RCG.LIST

#gather_osetplay.pl osetplay.log game*
#summarize_osetplay.pl osetplay.log >> osetplay.log

