#!/usr/local/bin/perl -w

$usage = "$0 <list of [gzipped] files with coach warning messages";

die $usage if (@ARGV == 0);

foreach $fn (@ARGV) {
  if ($fn =~ /\.gz$/) {
    $openarg = "gunzip -c $fn |";
  } else {
    $openarg = "< $fn";
  }

  $time = '----';
  open (FH, $openarg) || die "Could not open file '$fn' with '$openarg': $!";
  while (<FH>) {
    /^\s*CoachWarning\[10\] \((\d+)\): Time out waiting to hear from server/ || next;
    $time = $1;
    last;
  }
  print "$fn: $time\n";

  close (FH);
}
