#!//usr/local/bin/perl -w

# This script uses teh coach to log the ball owners and possessors based on a 
# logfile

use File::Basename;
use Cwd qw(abs_path);

$usage = "$0 <list of rcg files (can be gzipped)>";

die $usage if (@ARGV == 0);

$tmpfn = "/tmp/find_ball_owners.$$";

$coach_dir = dirname($0) . "/../coach";
foreach $fn (@ARGV) {
  die "File DNE '$fn'" if (not -e $fn);

  $fullfn = abs_path(dirname($fn)) . '/' . basename($fn);
  $outdir = abs_path(dirname($fn));

  $cmdline = "";
  $cmdline .= "cd $coach_dir; ";
  $cmdline .= "./coach --file coach.conf --file all_off.conf --use_mod_features ";
  $cmdline .= "--features_create_ball_owner_log --features_ball_owner_log_fn $outdir/ball_owner.log ";
  $cmdline .= "--features_create_ball_possess_log --features_ball_possess_log_fn $outdir/ball_possess.log ";
  $cmdline .= "--run_mode logfile --logfile_fn $fullfn ";

  print "Running '$cmdline'\n";
  system $cmdline;

}

unlink $tmpfn;
