#!/usr/local/bin/perl -w

# This script extracts the actions associated with the rules
# This is likely only useful for my advice by mdp stuff because it only prints
# actions that are do our {0}

use File::Basename;

$usage = "$0 <list of rcl file, maybe gzipped>";

$scriptdir = dirname($0);

#print (find_paren_balanced("(hello)") . "\n");
#print (find_paren_balanced("(hello (arg) (arg) (arg(arg)) )") . "\n");
#die;

die $usage if (@ARGV == 0);

foreach $rclfn (@ARGV) {

  print "Procssing $rclfn...\n";

  $outfn = dirname($rclfn) . "/rule_actions.log";
  open (OUTFH, ">$outfn") || die "Could not open out file '$outfn': $!";

  $cmdline = '';

  $cmdline .= ($rclfn =~ /.gz$/) ? "gunzip -c $rclfn" : "cat $rclfn";
  $cmdline .= "| $scriptdir/extract_coach_say.pl ";
  $cmdline .= "| $scriptdir/format_coach_say.pl ";

  open(PROC, "$cmdline|") || die "Could not open process '$cmdline': $!";

  $last_rule_name = "UNDEF";
  while (<PROC>) {
    if (/^\s*\(\s*definerule\s+(\w+)\s+direc/) {
      $last_rule_name = $1;
      print OUTFH "\n$last_rule_name :";
    } elsif (/^\s*\(\s*do\s+our\s+\{0\}\s+(.*)$/) {
      print OUTFH (" " . find_paren_balanced($1));
    }
  }
  print OUTFH "\n";
}

sub find_paren_balanced
  {
    my ($inputstr) = @_;
    my $idx = 0;
    my $open_cnt = 0;
    my $ch;
    for (;;) {
      $ch = substr($inputstr, $idx, 1);
      $open_cnt++ if ($ch eq '(');
      $open_cnt-- if ($ch eq ')');
      $idx++;
      last if ($open_cnt == 0);
    }
    return substr($inputstr, 0, $idx);
  }
