#!/usr/local/bin/perl5 -w

# This script extracts all coach says from the given logfile

$usage = "$0 [<rcl fn>]";

use vars qw($time $team $usage);

$accum = "";
$curr_accum = 0;
while (<>) {
  chomp;

  if ($curr_accum) {
    #$accum .= "\n";
    $accum .= $_;
  } else {
    next if (not /^(\d+)\s*Recv\s*([^:]+)_Coach\s*:\s*(.*)$/);
    # we have a coach utterance
    $time = $1;
    $team = $2;
    $command = $3;

    next if ($command =~ /freeform/);
    next if (not ($command =~ /^\s*\(\s*say/));

    $accum = $command;
  }

  if (is_paren_balanced($accum)) {
    ($accum =~ s/\)\s*$//) || die "Could not remove trailing";
    ($accum =~ s/^\s*\(\s*say\s*//) || die "could not remove say";
    die "I unbalanced" if (!is_paren_balanced($accum));
    $accum =~ s/\s+/ /g;
    print "$accum\n";
    $accum = "";
    $curr_accum = 0;
  } else {
    $curr_accum = 1;
  }

}

sub is_paren_balanced  {
  my ($str) = join '',@_;
  my ($cnt1, $cnt2, @arr);
  @arr = ($str =~ m/\(/g) ;
  $cnt1 = scalar @arr;
  @arr = ($str =~ m/\)/g) ;
  $cnt2 = scalar @arr;
  return $cnt1 == $cnt2;
}
