#!/usr/local/bin/perl

# Extracts a list of the Coach error messages from gzipped logfiles

$usage = "$0 <list of gz logfiles>";

foreach $gzfn (@ARGV) {
  open (PROC, "gunzip -c $gzfn |") || die "Could not open gzip process: $!";
  while ($_ = <PROC>) {
    next if (not /CoachError/);
    # kind of a tmp hack
    next if (/\(3000\): setBallOwner: I don.t think we should be in BeforeKickOff here 300/);
    print "$gzfn: $_";
  }
  close(GREPPROC);
}
