#!/usr/local/bin/perl5 -w

# Takes the output of diff mode of compare_coach_agent_views and draw some state diff

use File::Basename;

$usage = "$0 <output prefix> [<list of input files>]";

$outprefix = shift @ARGV;
die $usage unless defined($outprefix);

$coachdir = dirname($0) . "/../coach";

while (<>)
  {
    chomp;
    s/\#.*//;
    next if (/^\s*$/);

    /^(\d+)\s*:\s*(\w+)\s*([\s\d]*)$/ || die "Malformatted line";
    ($time, $match, @states) = ($1, $2, (split /\s+/, $3));

    next if ($match eq 'AgreeNone');
    next if ($match eq 'CoachOnly');

    next if (@states == 0);

    @tmpfiles = ();
    foreach $state (@states) {
      $tmpfn = "/tmp/draw_state_diff_$state";
      system "cd $coachdir; ./coach --file coach.conf --file all_off.conf --run_mode single --use_mod_abstract --abstract_draw_states --abstract_draw_state_num $state --abstract_draw_state_out_fpat $tmpfn --abstract_draw_scale 3";
      push @tmpfiles, "$tmpfn.png";
    }

    #-draw 'text 0,0 \"$match\"'
    system "montage -geometry \"0<\" -tile 10x10 " . (join ' ', @tmpfiles) . " $outprefix$time.png";

    unlink @tmpfiles;
  }
