#!/usr/local/bin/perl5 -w

use Cwd qw(abs_path);

$rootsoccerdir = "/usr0/pfr/soccer/coachteam";
$bindir = "$rootsoccerdir/bin";
$coachdir = "$rootsoccerdir/coach";


$usage = "$0 <dir of games>";

$dir = shift @ARGV;
die $usage if (!defined($dir));
$dir = abs_path($dir);
die "Game directory does not exist" if (not -d $dir);

mkdir ("$dir/absstate", 0770); #don't care if it fails; may already exist
system ("cd $bindir; ./coach_analyze_logs.pl absstate_left $dir/absstate $dir/game??/*.rcg.gz");
system ("cd $dir; ls */*absstate_cycle* > cycle_files.list");
system ("cd $coachdir; ./coach --file coach.conf --run_mode single --abstract_learn_markov_chain --abstract_learn_markov_chain_in_fn $dir/cycle_files.list --abstract_learn_markov_chain_out_fn $dir/learned.mc --abstract_learn_markov_chain_new_states_fn $dir/learned_mc_new_states.log --abstract_learn_markov_chain_new_tran_fn $dir/learned_mc_new_tran.log");
system ("cd $coachdir; ./coach --file coach.conf --run_mode single --use_mod_abstract --abstract_compare_state_trace_to_model --abstract_compare_st2m_in_list_fn $dir/cycle_files.list --abstract_compare_st2m_ignore_self_tran_min 0 --abstract_compare_st2m_ignore_self_tran_max 122 > $dir/trace_analysis");

chdir ($dir) || die "Could not change to target dir '$dir': $!";

open(GPPROC, "|gnuplot") || die "Could not open gnuplot: $!";
print GPPROC <<EOF;
set term postscript eps color
set output 'learned_mc_new_states.log.eps'
plot 'learned_mc_new_states.log' using column(-1):2
set term postscript eps color
set output 'learned_mc_new_tran.log.eps'
plot 'learned_mc_new_tran.log' using column(-1):2
EOF
