#!/usr/local/bin/perl -w

# This script looks at abmdp_track.log file (tracking of adbstract states)
# in order to determine count of actions

use File::Basename;
use Cwd qw(abs_path);

$usage = "$0 <abmdp_track.log[.gz] file>";

$infn = shift @ARGV;
die $usage unless (defined $infn);

@matchstr = ();
push @matchstr, '\( *shoot';
push @matchstr, '\( *dribble';
push @matchstr, '\( *pass';
push @matchstr, '\( *clear';
push @matchstr, '\( *pos';
push @matchstr, '\( *hold';
@matchcnt = (0) x @matchstr;

print "# infn: $infn\n";
$pwd = `pwd`;
chomp $pwd;
print "# pwd: $pwd\n";

$cmd = ($infn =~ /\.gz$/) ? "gunzip -c $infn |" : "cat $infn |";

open (CMD, $cmd) || die "Could not open process '$cmd': $!";
while (<CMD>)
  {
    chomp;
    s/\#.*//;
    next if (/^\s*$/);
    /^\s* [-\d]+ \s+ [-\d]+ \s+ [-\d+] \s* (.*)$/x || die "Malformatted line '$_'";
    $remain = $1;
    next if ($remain =~ /^\s*$/);
    # Note, this won't be right for complicated commands
    @comms = split /\)\s*/, $remain;
    foreach $comm (@comms) 
      {
	next if ($comm =~ /^\s*$/);
	$thismatchcnt = 0;
	$matchidx = -1;
	foreach $m (@matchstr) {
	  ++$matchidx;
	  ($comm =~ /$m/) || next;
	  ++($matchcnt[$matchidx]);
	  ++$thismatchcnt;
	}
	warn "Weird thismatchcnt $thismatchcnt on '$comm'" if ($thismatchcnt != 1);
      }
  }

foreach $m (@matchstr)
  {
    print "$m: " . (shift @matchcnt) . "\n";
  }
