#!/usr/local/bin/perl -w

# This script looks at an rcl file and counts the occurence of various strings
# (intended to match actions) based on the output of extract_coach_say and 
# format_coach_say

use File::Basename;
use Cwd qw(abs_path);

$usage = "$0 <.rcl or .rcl.gz file>";

$infn = shift @ARGV;
die $usage unless (defined $infn);

$scriptdir = abs_path(dirname($0));

@matchstr = ();
push @matchstr, '\( *shoot';
push @matchstr, '\( *dribble';
push @matchstr, '\( *pass';
push @matchstr, '\( *clear';
push @matchstr, '\( *pos';
push @matchstr, '\( *hold';
@matchcnt = (0) x @matchstr;

$cmd = ($infn =~ /\.gz$/) ? "gunzip -c $infn |" : "cat $infn |";
$cmd .= "$scriptdir/extract_coach_say.pl |";
$cmd .= "$scriptdir/format_coach_say.pl |";

open (CMD, $cmd) || die "Could not open process '$cmd': $!";
while (<CMD>)
  {
    # hack to stop at the end of my beginning advice
    last if /^\s* \(\s* definerule \s* SP_/;
    /^\s* \( \s* do \s* our \s* \{[^\}]+\} \s* (.*)/x || next;
    $remain = $1;
    $matchidx = -1;
    $thismatchcnt = 0;
    foreach $m (@matchstr) 
      {
	++$matchidx;
	($remain =~ /$m/) || next;
	++($matchcnt[$matchidx]);
	++$thismatchcnt;
      }
    warn "Weird thismatchcnt $thismatchcnt on '$remain'" if ($thismatchcnt != 1);
  }

foreach $m (@matchstr)
  {
    print "$m: " . (shift @matchcnt) . "\n";
  }
