#!/usr/local/bin/perl5 -ws

# This script computes the average score given a list of results output from svtool -r

# pass -compact on the command line to get compact reporting

use Statistics::Descriptive;

use vars qw($compact);

$Slteamscore = Statistics::Descriptive::Sparse->new();
$Srteamscore = Statistics::Descriptive::Sparse->new();
$Sscorediff = Statistics::Descriptive::Sparse->new();

while (<>) {
  s/\#.*//;
  next if (/^\s*$/);
  (undef, undef, $lscore, $rscore) = split;
  $Slteamscore->add_data($lscore);
  $Srteamscore->add_data($rscore);
  $Sscorediff->add_data($lscore - $rscore);
}

if ($Sscorediff->count() < 30) {
  $_ = $Sscorediff->count();
  warn "Computing a confidence interval with less than 30 data points may be inaccurate (only $_ data points)";
  print "# Computing a confidence interval with less than 30 data points may be inaccurate (only $_ data points)\n";
}

#The score diff is the only stat which can reasonably be assumed to have a 
# normal distribution (since the team scores are >= 0)
$lm = $Slteamscore->mean();
$ls = $Slteamscore->standard_deviation();
$rm = $Srteamscore->mean();
$rs = $Srteamscore->standard_deviation();
$sdm = $Sscorediff->mean();
$sds = $Sscorediff->standard_deviation();

$confval = 0.95;
$z = 1.96; #This is a 95% confidence interval
$len = $z * ($sds / sqrt($Sscorediff->count()) );

$L = $sdm - $len;
$U = $sdm + $len;

if (defined($compact)) {
  print "#lscore_mean lscore_stdev rscore_mean rscore_stdev scorediff_mean scorediff_stdev ${confval}_L ${confval}_U\n";
  print "$lm $ls $rm $rs $sdm $sds $L $U";
} else {
  print "#Left  team: $lm (stdev: $ls)\n";
  print "#Right team: $rm (stdev: $rs)\n";
  print "#Score diff: $sdm (stdev: $sds); \n#$confval confidence interval [$L,$U], length/2=$len\n";
}
