#!/bin/sh

# takes one argument of a directory

set -x

if test x$1 = x; then
    echo "usage: $0 <game directory>"
    exit -1
fi

cd $1 || exit -1

fn=`echo LOG*l/tree2state.log*`
if test x$fn != x; then
    cd LOG*l
    gunzip ?-matched.log.gz ??-matched.log.gz tree2state.log.gz abmdp_track.log.gz

    combine_matched_files.pl ?-matched.log ??-matched.log > combine-matched.log

    compare_coach_agent_views.pl summary tree2state.log abmdp_track.log combine-matched.log > compare_state_summary.log
    compare_coach_agent_views.pl cycle tree2state.log abmdp_track.log combine-matched.log > compare_state_cycle.log

    # now consider only the ball owner
    prune_matched.pl ../ball_possess.log left combine-matched.log > bp-matched.log
    compare_coach_agent_views.pl summary tree2state.log abmdp_track.log bp-matched.log > bp_compare_state_summary.log
    compare_coach_agent_views.pl cycle tree2state.log abmdp_track.log bp-matched.log > bp_compare_state_cycle.log

    gzip -f *.log
    cd ..
fi